/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.beautiful_statistics_screen.util.StatFormatter;

public class StatComparisonScreen
extends class_437 {
    private static final int COLUMN_WIDTH = 200;
    private static final int ENTRY_HEIGHT = 20;
    private static final int PADDING = 10;
    private final class_437 parent;
    private final String player1Name;
    private final Map<String, Long> player1Stats;
    private final String player2Name;
    private final Map<String, Long> player2Stats;
    private int scrollOffset = 0;
    private final List<ComparisonEntry> entries;

    public StatComparisonScreen(class_437 parent, String player1Name, Map<String, Long> player1Stats, String player2Name, Map<String, Long> player2Stats) {
        super((class_2561)class_2561.method_43470((String)"Stat Comparison"));
        this.parent = parent;
        this.player1Name = player1Name;
        this.player1Stats = player1Stats;
        this.player2Name = player2Name;
        this.player2Stats = player2Stats;
        this.entries = new ArrayList<ComparisonEntry>();
        this.buildComparisonEntries();
    }

    private void buildComparisonEntries() {
        HashMap<String, Long> allStats = new HashMap<String, Long>(this.player1Stats);
        this.player2Stats.forEach(allStats::putIfAbsent);
        for (String statKey : allStats.keySet()) {
            long value1 = this.player1Stats.getOrDefault(statKey, 0L);
            long value2 = this.player2Stats.getOrDefault(statKey, 0L);
            if (value1 == 0L && value2 == 0L) continue;
            this.entries.add(new ComparisonEntry(statKey, value1, value2));
        }
        this.entries.sort((a, b) -> Long.compare(Math.abs(b.value2 - b.value1), Math.abs(a.value2 - a.value1)));
    }

    protected void method_25426() {
        super.method_25426();
        class_4185 backButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.done"), btn -> this.method_25419()).method_46434((this.field_22789 - 200) / 2, this.field_22790 - 30, 200, 20).method_46431();
        this.method_37063((class_364)backButton);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(graphics);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 10, 0xFFFFFF);
        int headerY = 30;
        int col1X = this.field_22789 / 2 - 200 - 50;
        int col2X = this.field_22789 / 2 + 50;
        graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)("\u00a7b" + this.player1Name)), col1X + 100, headerY, 0xFFFFFF);
        graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)("\u00a7b" + this.player2Name)), col2X + 100, headerY, 0xFFFFFF);
        this.renderComparisonList(graphics, col1X, col2X);
        super.method_25394(graphics, mouseX, mouseY, partialTick);
    }

    private void renderComparisonList(class_332 graphics, int col1X, int col2X) {
        int listY = 50;
        int listHeight = this.field_22790 - 90;
        graphics.method_25294(col1X - 10, listY, col2X + 200 + 10, listY + listHeight, Integer.MIN_VALUE);
        int entryY = listY + 10 - this.scrollOffset;
        for (ComparisonEntry entry : this.entries) {
            if (entryY + 20 < listY || entryY > listY + listHeight) {
                entryY += 20;
                continue;
            }
            String statName = this.formatStatName(entry.statKey);
            int nameX = this.field_22789 / 2 - this.field_22793.method_1727(statName) / 2;
            graphics.method_25303(this.field_22793, statName, nameX, entryY + 5, 0xCCCCCC);
            String value1Str = StatFormatter.formatValue(entry.value1);
            int value1Color = entry.value1 > entry.value2 ? 65280 : (entry.value1 < entry.value2 ? 0xFF0000 : 0xFFFFFF);
            graphics.method_25303(this.field_22793, value1Str, col1X + 200 - this.field_22793.method_1727(value1Str), entryY + 5, value1Color);
            String value2Str = StatFormatter.formatValue(entry.value2);
            int value2Color = entry.value2 > entry.value1 ? 65280 : (entry.value2 < entry.value1 ? 0xFF0000 : 0xFFFFFF);
            graphics.method_25303(this.field_22793, value2Str, col2X, entryY + 5, value2Color);
            long diff = entry.value2 - entry.value1;
            if (diff != 0L) {
                String diffStr = (diff > 0L ? "+" : "") + StatFormatter.formatValue(diff);
                graphics.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)("\u00a77(" + diffStr + ")")), col2X + 200 + 10, entryY + 5, 0x888888);
            }
            entryY += 20;
        }
    }

    private String formatStatName(String statKey) {
        String[] parts = statKey.split("[:/]");
        if (parts.length > 0) {
            String name = parts[parts.length - 1];
            return name.replace("_", " ").substring(0, 1).toUpperCase() + name.replace("_", " ").substring(1);
        }
        return statKey;
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        int maxScroll = Math.max(0, this.entries.size() * 20 - (this.field_22790 - 140));
        this.scrollOffset = Math.max(0, Math.min(maxScroll, this.scrollOffset - (int)(delta * 20.0)));
        return true;
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    private static class ComparisonEntry {
        final String statKey;
        final long value1;
        final long value2;

        ComparisonEntry(String statKey, long value1, long value2) {
            this.statKey = statKey;
            this.value1 = value1;
            this.value2 = value2;
        }
    }
}

