/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.texboobcat.beautiful_statistics_screen.api.StatEntry;
import org.texboobcat.beautiful_statistics_screen.config.ModConfig;
import org.texboobcat.beautiful_statistics_screen.util.StatFormatter;

public class StatGridWidget
extends class_339 {
    private static final int ITEM_SIZE = 40;
    private static final int ITEM_SPACING = 5;
    private static final int PADDING = 5;
    private final class_310 minecraft;
    private List<StatEntry> stats = new ArrayList<StatEntry>();
    private int scrollOffset = 0;
    private final Consumer<StatEntry> onLeftClick;
    private final Consumer<StatEntry> onRightClick;
    private StatEntry hoveredEntry = null;

    public StatGridWidget(class_310 minecraft, int x, int y, int width, int height, Consumer<StatEntry> onLeftClick, Consumer<StatEntry> onRightClick) {
        super(x, y, width, height, (class_2561)class_2561.method_43473());
        this.minecraft = minecraft;
        this.onLeftClick = onLeftClick;
        this.onRightClick = onRightClick;
    }

    public void setStats(List<StatEntry> stats) {
        this.stats = new ArrayList<StatEntry>(stats);
        if (this.scrollOffset > this.getMaxScroll()) {
            this.scrollOffset = Math.max(0, this.getMaxScroll());
        }
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        int y;
        int x;
        int row;
        int col;
        graphics.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, Integer.MIN_VALUE);
        this.hoveredEntry = null;
        int columns = Math.max(1, (this.field_22758 - 10) / 45);
        int itemX = this.method_46426() + 5;
        int itemY = this.method_46427() + 5 - this.scrollOffset;
        int index = 0;
        for (StatEntry entry : this.stats) {
            boolean hovered;
            col = index % columns;
            row = index / columns;
            x = itemX + col * 45;
            y = itemY + row * 45;
            if (y + 40 < this.method_46427() || y > this.method_46427() + this.field_22759) {
                ++index;
                continue;
            }
            boolean bl = hovered = mouseX >= x && mouseX < x + 40 && mouseY >= y && mouseY < y + 40;
            if (hovered) {
                this.hoveredEntry = entry;
            }
            boolean pinned = ModConfig.isPinned(entry.getStatId());
            int bgColor = hovered ? -2141167520 : -2143272896;
            graphics.method_25294(x, y, x + 40, y + 40, bgColor);
            if (pinned) {
                graphics.method_25294(x, y, x + 40, y + 2, -256);
            }
            if (entry.getIconRenderer() != null) {
                int iconSize = 36;
                int iconX = x + 2;
                int iconY = y + 2;
                entry.getIconRenderer().render(graphics, iconX, iconY, iconSize);
            }
            if (hovered) {
                graphics.method_25294(x, y, x + 40, y + 1, -1);
                graphics.method_25294(x, y + 40 - 1, x + 40, y + 40, -1);
                graphics.method_25294(x, y, x + 1, y + 40, -1);
                graphics.method_25294(x + 40 - 1, y, x + 40, y + 40, -1);
            }
            ++index;
        }
        index = 0;
        for (StatEntry entry : this.stats) {
            col = index % columns;
            row = index / columns;
            x = itemX + col * 45;
            y = itemY + row * 45;
            if (y + 40 < this.method_46427() || y > this.method_46427() + this.field_22759) {
                ++index;
                continue;
            }
            String valueStr = StatFormatter.formatStatValue(entry.getStatId(), entry.getValue());
            valueStr = valueStr.replaceAll("\\s+[a-zA-Z]+$", "");
            int textWidth = this.minecraft.field_1772.method_1727(valueStr);
            int textX = x + (40 - textWidth) / 2;
            int textY = y + 40 - 10;
            graphics.method_25294(textX - 1, textY - 1, textX + textWidth + 1, textY + 9, -872415232);
            graphics.method_25303(this.minecraft.field_1772, valueStr, textX, textY, 0xFFFFFF);
            ++index;
        }
    }

    public void renderTooltip(class_332 graphics, int mouseX, int mouseY) {
        if (this.hoveredEntry != null) {
            ArrayList<Object> tooltip = new ArrayList<Object>();
            tooltip.add(this.hoveredEntry.getDisplayName());
            String formattedValue = StatFormatter.formatStatValue(this.hoveredEntry.getStatId(), this.hoveredEntry.getValue());
            tooltip.add(class_2561.method_43470((String)formattedValue));
            String rawValue = StatFormatter.formatValueFull(this.hoveredEntry.getValue());
            tooltip.add(class_2561.method_43470((String)("\u00a77Raw: " + rawValue)));
            if (!this.hoveredEntry.getDescription().getString().isEmpty()) {
                tooltip.add(this.hoveredEntry.getDescription());
            }
            if (ModConfig.isPinned(this.hoveredEntry.getStatId())) {
                tooltip.add(class_2561.method_43471((String)"gui.beautiful_statistics_screen.pinned_indicator"));
            } else {
                tooltip.add(class_2561.method_43471((String)"gui.beautiful_statistics_screen.right_click_to_pin"));
            }
            graphics.method_51437(this.minecraft.field_1772, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.hoveredEntry != null) {
            if (button == 0) {
                this.onLeftClick.accept(this.hoveredEntry);
            } else if (button == 1) {
                this.onRightClick.accept(this.hoveredEntry);
            }
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        int maxScroll = this.getMaxScroll();
        this.scrollOffset = Math.max(0, Math.min(maxScroll, this.scrollOffset - (int)(delta * 20.0)));
        return true;
    }

    private int getMaxScroll() {
        int columns = Math.max(1, (this.field_22758 - 10) / 45);
        int rows = (this.stats.size() + columns - 1) / columns;
        int totalHeight = rows * 45 + 10;
        return Math.max(0, totalHeight - this.field_22759);
    }

    protected void method_47399(class_6382 output) {
        output.method_37034(class_6381.field_33788, (class_2561)class_2561.method_43470((String)"Statistics Grid"));
    }
}

