/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.beautiful_statistics_screen.api.StatEntry;
import org.texboobcat.beautiful_statistics_screen.client.gui.AdvancedChartScreen;
import org.texboobcat.beautiful_statistics_screen.client.gui.widgets.TextStatListWidget;
import org.texboobcat.beautiful_statistics_screen.config.ModConfig;
import org.texboobcat.beautiful_statistics_screen.core.StatDataManager;

public class TextStatsScreen
extends class_437 {
    private static final int PADDING = 10;
    private final class_437 parent;
    private class_342 searchBox;
    private class_4185 hideZeroButton;
    private class_4185 sortButton;
    private TextStatListWidget listWidget;
    private boolean hideZero = true;
    private SortMode sortMode = SortMode.NAME_ASC;
    private List<StatEntry> allCustomStats = new ArrayList<StatEntry>();

    public TextStatsScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"screen.beautiful_statistics_screen.text_stats"));
        this.parent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        StatDataManager.refresh();
        this.allCustomStats = StatDataManager.getAllStats().stream().filter(e -> e.getStatId().method_12832().startsWith("custom/")).collect(Collectors.toCollection(ArrayList::new));
        int topY = 28;
        int leftX = 10;
        int buttonH = 20;
        int spacing = 5;
        int availableWidth = this.field_22789 - 20;
        int buttonWidth = 80;
        int searchBoxWidth = Math.max(200, availableWidth - buttonWidth * 3 - spacing * 4);
        this.searchBox = new class_342(this.field_22793, leftX, topY, searchBoxWidth, buttonH, (class_2561)class_2561.method_43470((String)"Search"));
        this.searchBox.method_1863(s -> this.updateList());
        this.searchBox.method_47404((class_2561)class_2561.method_43470((String)"Search stats..."));
        this.method_37063((class_364)this.searchBox);
        int btnX = leftX + searchBoxWidth + spacing;
        this.hideZeroButton = class_4185.method_46430((class_2561)this.labelForHide(), btn -> {
            this.hideZero = !this.hideZero;
            this.hideZeroButton.method_25355(this.labelForHide());
            this.updateList();
        }).method_46434(btnX, topY, buttonWidth, buttonH).method_46431();
        this.method_37063((class_364)this.hideZeroButton);
        this.sortButton = class_4185.method_46430((class_2561)this.labelForSort(), btn -> {
            this.sortMode = this.sortMode.next();
            this.sortButton.method_25355(this.labelForSort());
            this.updateList();
        }).method_46434(btnX += buttonWidth + spacing, topY, buttonWidth, buttonH).method_46431();
        this.method_37063((class_364)this.sortButton);
        class_4185 chartBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Chart"), btn -> {
            if (this.listWidget.getSelected() != null) {
                StatEntry selected = this.listWidget.getSelected();
                this.field_22787.method_1507((class_437)new AdvancedChartScreen(this, selected.getStatId(), selected.getDisplayName()));
            }
        }).method_46434(btnX += buttonWidth + spacing, topY, buttonWidth, buttonH).method_46431();
        this.method_37063((class_364)chartBtn);
        class_4185 back = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.done"), b -> this.method_25419()).method_46434((this.field_22789 - 200) / 2, this.field_22790 - 28, 200, 20).method_46431();
        this.method_37063((class_364)back);
        int listY = topY + buttonH + spacing;
        this.listWidget = new TextStatListWidget(this.field_22787, 10, listY, this.field_22789 - 20, this.field_22790 - listY - 40, this::onEntryClick, this::onEntryRightClick);
        this.method_37063((class_364)this.listWidget);
        this.updateList();
    }

    private class_2561 labelForHide() {
        return class_2561.method_43470((String)(this.hideZero ? "Hide Zero" : "Show Zero"));
    }

    private class_2561 labelForSort() {
        String s = switch (this.sortMode.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> "Name \u25b2";
            case 1 -> "Name \u25bc";
            case 2 -> "Value \u25b2";
            case 3 -> "Value \u25bc";
        };
        return class_2561.method_43470((String)s);
    }

    private void updateList() {
        String query = this.searchBox.method_1882() == null ? "" : this.searchBox.method_1882().toLowerCase(Locale.ROOT);
        List filtered = this.allCustomStats.stream().filter(e -> query.isEmpty() || e.getSearchableName().contains(query) || e.getStatId().toString().toLowerCase(Locale.ROOT).contains(query)).filter(e -> !this.hideZero || !e.isZero()).collect(Collectors.toCollection(ArrayList::new));
        Comparator<StatEntry> cmp = switch (this.sortMode.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> Comparator.comparing(a -> a.getDisplayName().getString());
            case 1 -> Comparator.comparing(a -> a.getDisplayName().getString()).reversed();
            case 2 -> Comparator.comparingLong(StatEntry::getValue);
            case 3 -> Comparator.comparingLong(StatEntry::getValue).reversed();
        };
        filtered.sort(cmp);
        this.listWidget.setStats(filtered);
    }

    private void onEntryClick(StatEntry entry) {
        if (ModConfig.isPinned(entry.getStatId())) {
            ModConfig.removePinnedStat(entry.getStatId());
        } else {
            ModConfig.addPinnedStat(entry.getStatId());
        }
    }

    private void onEntryRightClick(StatEntry entry) {
        if (this.field_22787 != null) {
            this.field_22787.method_1507((class_437)new AdvancedChartScreen(this, entry.getStatId(), entry.getDisplayName()));
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(graphics);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 8, 0xFFFFFF);
        super.method_25394(graphics, mouseX, mouseY, partialTick);
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    private static enum SortMode {
        NAME_ASC,
        NAME_DESC,
        VALUE_ASC,
        VALUE_DESC;


        public SortMode next() {
            return SortMode.values()[(this.ordinal() + 1) % SortMode.values().length];
        }
    }
}

