/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.client.gui.widgets;

import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.texboobcat.beautiful_statistics_screen.client.gui.chart.ChartDataset;
import org.texboobcat.beautiful_statistics_screen.util.StatFormatter;

public class StatisticsPanel
extends class_339 {
    private final class_310 minecraft;
    private final List<ChartDataset> datasets;
    private int scrollOffset = 0;

    public StatisticsPanel(class_310 minecraft, int x, int y, int width, int height, List<ChartDataset> datasets) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)"Statistics"));
        this.minecraft = minecraft;
        this.datasets = datasets;
    }

    protected void method_47399(class_6382 output) {
        output.method_37034(class_6381.field_33788, (class_2561)class_2561.method_43470((String)"Statistics Panel"));
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        if (!this.field_22764) {
            return;
        }
        graphics.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, -805306368);
        graphics.method_25303(this.minecraft.field_1772, "Statistics", this.method_46426() + 6, this.method_46427() + 6, 0xFFFFFF);
        int y = this.method_46427() + 20 - this.scrollOffset;
        int x = this.method_46426() + 10;
        for (ChartDataset dataset : this.datasets) {
            ChartDataset.TrendLine trend;
            if (!dataset.isVisible()) continue;
            if (y > this.method_46427() + this.field_22759 || y < this.method_46427() + 20) {
                y += this.calculateDatasetHeight(dataset);
                continue;
            }
            graphics.method_25294(x - 4, y, x - 2, y + 10, dataset.getColor());
            Object name = dataset.getDisplayName().getString();
            if (((String)name).length() > 25) {
                name = ((String)name).substring(0, 22) + "...";
            }
            graphics.method_25303(this.minecraft.field_1772, (String)name, x, y, 0xFFFFFF);
            ChartDataset.DatasetStatistics stats = dataset.getStatistics();
            this.drawStat(graphics, x, y += 12, "Min", StatFormatter.formatValue(stats.min()));
            this.drawStat(graphics, x, y += 10, "Max", StatFormatter.formatValue(stats.max()));
            this.drawStat(graphics, x, y += 10, "Mean", String.format("%.2f", stats.mean()));
            this.drawStat(graphics, x, y += 10, "Median", StatFormatter.formatValue(stats.median()));
            this.drawStat(graphics, x, y += 10, "StdDev", String.format("%.2f", stats.standardDeviation()));
            this.drawStat(graphics, x, y += 10, "Range", StatFormatter.formatValue(stats.getRange()));
            y += 10;
            if (dataset.isShowTrendLine() && (trend = dataset.calculateTrendLine()) != null) {
                String direction = trend.slope() > 0.0 ? "\u2191" : (trend.slope() < 0.0 ? "\u2193" : "\u2192");
                String trendStr = direction + " " + String.format("%.4f", Math.abs(trend.slope()));
                graphics.method_25303(this.minecraft.field_1772, "Trend: " + trendStr, x, y, 0xFFAA00);
                y += 10;
            }
            y += 8;
        }
        if (this.getMaxScroll() > 0) {
            int scrollBarHeight = Math.max(20, this.field_22759 * this.field_22759 / this.getTotalHeight());
            int scrollBarY = this.method_46427() + 20 + (int)((float)this.scrollOffset / (float)this.getMaxScroll() * (float)(this.field_22759 - 20 - scrollBarHeight));
            graphics.method_25294(this.method_46426() + this.field_22758 - 4, scrollBarY, this.method_46426() + this.field_22758 - 2, scrollBarY + scrollBarHeight, -16733441);
        }
    }

    private void drawStat(class_332 graphics, int x, int y, String label, String value) {
        graphics.method_25303(this.minecraft.field_1772, label + ":", x, y, 0x888888);
        graphics.method_25303(this.minecraft.field_1772, value, x + 60, y, 0xCCCCCC);
    }

    private int calculateDatasetHeight(ChartDataset dataset) {
        int height = 72;
        if (dataset.isShowTrendLine()) {
            height += 10;
        }
        return height + 8;
    }

    private int getTotalHeight() {
        return this.datasets.stream().filter(ChartDataset::isVisible).mapToInt(this::calculateDatasetHeight).sum() + 20;
    }

    private int getMaxScroll() {
        return Math.max(0, this.getTotalHeight() - this.field_22759);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (!this.field_22764) {
            return false;
        }
        this.scrollOffset = Math.max(0, Math.min(this.getMaxScroll(), this.scrollOffset - (int)(delta * 20.0)));
        return true;
    }
}

