/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.texboobcat.beautiful_statistics_screen.history.HistoryManager;

public class HistoryCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"statshistory").then(class_2170.method_9247((String)"info").executes(HistoryCommand::executeInfo))).then(class_2170.method_9247((String)"stats").executes(HistoryCommand::executeStats))).then(class_2170.method_9247((String)"list").executes(HistoryCommand::executeList))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear").then(class_2170.method_9244((String)"stat", (ArgumentType)StringArgumentType.string()).executes(HistoryCommand::executeClearStat))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"all").requires(source -> source.method_9259(2))).executes(HistoryCommand::executeClearAll))));
    }

    private static int executeInfo(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        HistoryManager.CompressionStats stats = HistoryManager.getCompressionStats();
        long lastLogTime = HistoryManager.getLastLogTime();
        int statsWithHistory = HistoryManager.getStatsWithHistory().size();
        source.method_9226(() -> class_2561.method_43470((String)"\u00a76=== Statistics History Info ==="), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7eStats being tracked: \u00a7f" + statsWithHistory)), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7eTotal history files: \u00a7f" + stats.getTotalFileCount())), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7eCompressed files: \u00a7a" + stats.compressedFileCount)), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7eUncompressed files: \u00a77" + stats.uncompressedFileCount)), false);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7eTotal disk usage: \u00a7f" + stats.getFormattedSize())), false);
        if (lastLogTime > 0L) {
            long secondsSinceLog = (System.currentTimeMillis() - lastLogTime) / 1000L;
            long minutes = secondsSinceLog / 60L;
            long seconds = secondsSinceLog % 60L;
            source.method_9226(() -> class_2561.method_43470((String)("\u00a7eLast log: \u00a7f" + minutes + "m " + seconds + "s ago")), false);
        } else {
            source.method_9226(() -> class_2561.method_43470((String)"\u00a7eLast log: \u00a77Never"), false);
        }
        if (stats.compressedFileCount > 0L && stats.uncompressedFileCount > 0L) {
            source.method_9226(() -> class_2561.method_43470((String)"\u00a7eMixed compression format detected"), false);
        } else if (stats.compressedFileCount > 0L) {
            source.method_9226(() -> class_2561.method_43470((String)"\u00a7aAll files compressed"), false);
        }
        return 1;
    }

    private static int executeStats(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        List<class_2960> trackedStats = HistoryManager.getStatsWithHistory();
        if (trackedStats.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)"\u00a7cNo statistics are being tracked"), false);
            return 0;
        }
        source.method_9226(() -> class_2561.method_43470((String)("\u00a76=== Tracked Statistics (" + trackedStats.size() + ") ===")), false);
        int limit = Math.min(20, trackedStats.size());
        for (int i = 0; i < limit; ++i) {
            class_2960 stat = trackedStats.get(i);
            List<HistoryManager.DataPoint> history = HistoryManager.getHistory(stat);
            int dataPoints = history.size();
            source.method_9226(() -> class_2561.method_43470((String)("\u00a7e" + String.valueOf(stat) + " \u00a77(" + dataPoints + " points)")), false);
        }
        if (trackedStats.size() > 20) {
            int remaining = trackedStats.size() - 20;
            source.method_9226(() -> class_2561.method_43470((String)("\u00a77... and " + remaining + " more")), false);
        }
        return 1;
    }

    private static int executeList(CommandContext<class_2168> context) {
        return HistoryCommand.executeStats(context);
    }

    private static int executeClearStat(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String statIdStr = StringArgumentType.getString(context, (String)"stat");
        try {
            class_2960 statId = new class_2960(statIdStr);
            HistoryManager.clearHistory(statId);
            source.method_9226(() -> class_2561.method_43470((String)("\u00a7aCleared history for: \u00a7f" + String.valueOf(statId))), false);
            return 1;
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("\u00a7cInvalid stat ID: " + statIdStr)));
            return 0;
        }
    }

    private static int executeClearAll(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        int count = HistoryManager.getStatsWithHistory().size();
        HistoryManager.clearAllHistory();
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7aCleared all history data for " + count + " statistics")), false);
        return 1;
    }
}

