/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3445;
import net.minecraft.class_3468;
import net.minecraft.class_7923;
import org.texboobcat.beautiful_statistics_screen.Beautiful_statistics_screen;
import org.texboobcat.beautiful_statistics_screen.config.ModConfig;

public class StatsCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"statistics").requires(source -> !ModConfig.getServer().requireOpForCommands || source.method_9259(2))).then(class_2170.method_9247((String)"view").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).executes(ctx -> StatsCommand.viewStats((CommandContext<class_2168>)ctx, class_2186.method_9312((CommandContext)ctx, (String)"targets")))))).then(class_2170.method_9247((String)"clear").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).executes(ctx -> StatsCommand.clearStats((CommandContext<class_2168>)ctx, class_2186.method_9312((CommandContext)ctx, (String)"targets"), null))).then(class_2170.method_9244((String)"stat", (ArgumentType)StringArgumentType.string()).suggests(StatsCommand.statSuggestions()).executes(ctx -> StatsCommand.clearStats((CommandContext<class_2168>)ctx, class_2186.method_9312((CommandContext)ctx, (String)"targets"), StringArgumentType.getString((CommandContext)ctx, (String)"stat"))))))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"stat", (ArgumentType)StringArgumentType.string()).suggests(StatsCommand.statSuggestions()).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> StatsCommand.setStat((CommandContext<class_2168>)ctx, class_2186.method_9312((CommandContext)ctx, (String)"targets"), StringArgumentType.getString((CommandContext)ctx, (String)"stat"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value")))))))).then(class_2170.method_9247((String)"increase").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"stat", (ArgumentType)StringArgumentType.string()).suggests(StatsCommand.statSuggestions()).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> StatsCommand.increaseStat((CommandContext<class_2168>)ctx, class_2186.method_9312((CommandContext)ctx, (String)"targets"), StringArgumentType.getString((CommandContext)ctx, (String)"stat"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount"))))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"stats").requires(source -> !ModConfig.getServer().requireOpForCommands || source.method_9259(2))).redirect(dispatcher.getRoot().getChild("statistics")));
    }

    private static SuggestionProvider<class_2168> statSuggestions() {
        return (context, builder) -> {
            class_2172.method_9253((String[])new String[]{"minecraft:custom/jump", "minecraft:custom/walk_one_cm", "minecraft:custom/run_one_cm", "minecraft:custom/damage_dealt", "minecraft:custom/damage_taken", "minecraft:custom/deaths", "minecraft:custom/play_time", "minecraft:used/diamond_pickaxe", "minecraft:crafted/diamond_sword", "minecraft:mined/stone", "minecraft:killed/zombie", "minecraft:killed_by/creeper"}, (SuggestionsBuilder)builder);
            return builder.buildFuture();
        };
    }

    private static int viewStats(CommandContext<class_2168> ctx, Collection<class_3222> targets) {
        class_2168 source = (class_2168)ctx.getSource();
        for (class_3222 player : targets) {
            source.method_9226(() -> class_2561.method_43470((String)("Statistics for " + player.method_5477().getString() + ":")), false);
            StatsCommand.showStat(source, player, class_3468.field_15419.method_14956((Object)class_3468.field_15421), "Deaths");
            StatsCommand.showStat(source, player, class_3468.field_15419.method_14956((Object)class_3468.field_15399), "Damage Dealt");
            StatsCommand.showStat(source, player, class_3468.field_15419.method_14956((Object)class_3468.field_15388), "Damage Taken");
            StatsCommand.showStat(source, player, class_3468.field_15419.method_14956((Object)class_3468.field_15417), "Play Time");
            StatsCommand.showStat(source, player, class_3468.field_15419.method_14956((Object)class_3468.field_15428), "Jumps");
        }
        return targets.size();
    }

    private static void showStat(class_2168 source, class_3222 player, class_3445<?> stat, String name) {
        int value = player.method_14248().method_15025(stat);
        source.method_9226(() -> class_2561.method_43470((String)("  " + name + ": " + value)), false);
    }

    private static int clearStats(CommandContext<class_2168> ctx, Collection<class_3222> targets, String statPath) {
        class_2168 source = (class_2168)ctx.getSource();
        for (class_3222 player : targets) {
            if (statPath == null) {
                player.method_7266(class_3468.field_15419.method_14956((Object)class_3468.field_15421));
                player.method_7266(class_3468.field_15419.method_14956((Object)class_3468.field_15399));
                player.method_7266(class_3468.field_15419.method_14956((Object)class_3468.field_15388));
                if (ModConfig.getServer().logStatChanges) {
                    Beautiful_statistics_screen.LOGGER.info("Cleared all stats for player: " + player.method_5477().getString());
                }
                source.method_9226(() -> class_2561.method_43470((String)("Cleared all statistics for " + player.method_5477().getString())), true);
                continue;
            }
            class_3445<?> stat = StatsCommand.parseStat(statPath);
            if (stat != null) {
                player.method_7266(stat);
                if (ModConfig.getServer().logStatChanges) {
                    Beautiful_statistics_screen.LOGGER.info("Cleared stat " + statPath + " for player: " + player.method_5477().getString());
                }
                source.method_9226(() -> class_2561.method_43470((String)("Cleared statistic " + statPath + " for " + player.method_5477().getString())), true);
                continue;
            }
            source.method_9213((class_2561)class_2561.method_43470((String)("Unknown statistic: " + statPath)));
            return 0;
        }
        return targets.size();
    }

    private static int setStat(CommandContext<class_2168> ctx, Collection<class_3222> targets, String statPath, int value) {
        class_2168 source = (class_2168)ctx.getSource();
        class_3445<?> stat = StatsCommand.parseStat(statPath);
        if (stat == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Unknown statistic: " + statPath)));
            return 0;
        }
        for (class_3222 player : targets) {
            player.method_14248().method_15023((class_1657)player, stat, value);
            if (ModConfig.getServer().logStatChanges) {
                Beautiful_statistics_screen.LOGGER.info("Set stat " + statPath + " to " + value + " for player: " + player.method_5477().getString());
            }
            source.method_9226(() -> class_2561.method_43470((String)("Set " + statPath + " to " + value + " for " + player.method_5477().getString())), true);
        }
        return targets.size();
    }

    private static int increaseStat(CommandContext<class_2168> ctx, Collection<class_3222> targets, String statPath, int amount) {
        class_2168 source = (class_2168)ctx.getSource();
        class_3445<?> stat = StatsCommand.parseStat(statPath);
        if (stat == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Unknown statistic: " + statPath)));
            return 0;
        }
        for (class_3222 player : targets) {
            int currentValue = player.method_14248().method_15025(stat);
            int newValue = currentValue + amount;
            player.method_14248().method_15023((class_1657)player, stat, newValue);
            if (ModConfig.getServer().logStatChanges) {
                Beautiful_statistics_screen.LOGGER.info("Increased stat " + statPath + " by " + amount + " for player: " + player.method_5477().getString());
            }
            source.method_9226(() -> class_2561.method_43470((String)("Increased " + statPath + " by " + amount + " for " + player.method_5477().getString() + " (new value: " + newValue + ")")), true);
        }
        return targets.size();
    }

    private static class_3445<?> parseStat(String statPath) {
        try {
            class_2960 id = new class_2960(statPath);
            String[] parts = id.method_12832().split("/", 2);
            if (parts.length < 2) {
                return class_3468.field_15419.method_14956((Object)StatsCommand.getCustomStat(id.method_12832()));
            }
            String type = parts[0];
            String target = parts[1];
            class_2960 targetId = new class_2960(id.method_12836(), target);
            return switch (type) {
                case "used" -> {
                    class_1792 item = (class_1792)class_7923.field_41178.method_10223(targetId);
                    yield class_3468.field_15372.method_14956((Object)item);
                }
                case "crafted" -> {
                    class_1792 item = (class_1792)class_7923.field_41178.method_10223(targetId);
                    yield class_3468.field_15370.method_14956((Object)item);
                }
                case "broken" -> {
                    class_1792 item = (class_1792)class_7923.field_41178.method_10223(targetId);
                    yield class_3468.field_15383.method_14956((Object)item);
                }
                case "mined" -> {
                    class_2248 block = (class_2248)class_7923.field_41175.method_10223(targetId);
                    yield class_3468.field_15427.method_14956((Object)block);
                }
                case "killed" -> {
                    class_1299 entityType = (class_1299)class_7923.field_41177.method_10223(targetId);
                    yield class_3468.field_15403.method_14956((Object)entityType);
                }
                case "killed_by" -> {
                    class_1299 entityType = (class_1299)class_7923.field_41177.method_10223(targetId);
                    yield class_3468.field_15411.method_14956((Object)entityType);
                }
                default -> null;
            };
        }
        catch (Exception e) {
            return null;
        }
    }

    private static class_2960 getCustomStat(String name) {
        return switch (name.toLowerCase()) {
            case "jump" -> class_3468.field_15428;
            case "deaths" -> class_3468.field_15421;
            case "damage_dealt" -> class_3468.field_15399;
            case "damage_taken" -> class_3468.field_15388;
            case "play_time" -> class_3468.field_15417;
            default -> new class_2960("minecraft", "custom/" + name);
        };
    }
}

