/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.texboobcat.beautiful_statistics_screen.api.StatCategory;

public class StatCategoryRegistry {
    private static final Map<class_2960, StatCategory> CATEGORIES = new ConcurrentHashMap<class_2960, StatCategory>();
    private static final List<StatCategory> ORDERED_CATEGORIES = new ArrayList<StatCategory>();
    private static boolean initialized = false;
    public static final class_2960 GENERAL_ID = new class_2960("beautiful_statistics_screen", "general");
    public static final class_2960 ITEMS_ID = new class_2960("beautiful_statistics_screen", "items");
    public static final class_2960 MOBS_ID = new class_2960("beautiful_statistics_screen", "mobs");
    public static final class_2960 FOOD_ID = new class_2960("beautiful_statistics_screen", "food");
    public static final class_2960 HOSTILE_ID = new class_2960("beautiful_statistics_screen", "hostile");
    public static final class_2960 BLOCKS_ID = new class_2960("beautiful_statistics_screen", "blocks");
    public static final class_2960 CUSTOM_ID = new class_2960("beautiful_statistics_screen", "custom");

    public static synchronized void register(StatCategory category) {
        if (CATEGORIES.containsKey(category.getId())) {
            throw new IllegalStateException("Stat category already registered: " + String.valueOf(category.getId()));
        }
        CATEGORIES.put(category.getId(), category);
        ORDERED_CATEGORIES.add(category);
        ORDERED_CATEGORIES.sort(Comparator.comparingInt(StatCategory::getPriority));
    }

    public static StatCategory getCategory(class_2960 id) {
        return CATEGORIES.get(id);
    }

    public static List<StatCategory> getAllCategories() {
        return Collections.unmodifiableList(ORDERED_CATEGORIES);
    }

    public static synchronized void initializeDefaults() {
        if (initialized) {
            return;
        }
        initialized = true;
        StatCategoryRegistry.register(new StatCategory(GENERAL_ID, (class_2561)class_2561.method_43471((String)"category.beautiful_statistics_screen.general"), 0, id -> id.method_12832().startsWith("custom/")));
        StatCategoryRegistry.register(new StatCategory(FOOD_ID, (class_2561)class_2561.method_43471((String)"category.beautiful_statistics_screen.food"), 1, id -> id.method_12832().startsWith("used/") && StatCategoryRegistry.isFoodItem(id)));
        StatCategoryRegistry.register(new StatCategory(HOSTILE_ID, (class_2561)class_2561.method_43471((String)"category.beautiful_statistics_screen.hostile"), 2, id -> {
            String path = id.method_12832();
            return (path.startsWith("killed/") || path.startsWith("killed_by/")) && StatCategoryRegistry.isHostileMob(id);
        }));
        StatCategoryRegistry.register(new StatCategory(ITEMS_ID, (class_2561)class_2561.method_43471((String)"category.beautiful_statistics_screen.items"), 3, id -> id.method_12832().startsWith("used/") || id.method_12832().startsWith("crafted/") || id.method_12832().startsWith("broken/") || id.method_12832().startsWith("picked_up/") || id.method_12832().startsWith("dropped/")));
        StatCategoryRegistry.register(new StatCategory(MOBS_ID, (class_2561)class_2561.method_43471((String)"category.beautiful_statistics_screen.mobs"), 4, id -> id.method_12832().startsWith("killed/") || id.method_12832().startsWith("killed_by/")));
        StatCategoryRegistry.register(new StatCategory(BLOCKS_ID, (class_2561)class_2561.method_43471((String)"category.beautiful_statistics_screen.blocks"), 5, id -> id.method_12832().startsWith("mined/")));
        StatCategoryRegistry.register(new StatCategory(CUSTOM_ID, (class_2561)class_2561.method_43471((String)"category.beautiful_statistics_screen.custom"), 100, id -> id.method_12832().startsWith("custom_stat/")));
    }

    private static boolean isFoodItem(class_2960 statId) {
        String path = statId.method_12832();
        if (!path.startsWith("used/")) {
            return false;
        }
        String itemName = path.substring("used/".length());
        class_2960 itemId = new class_2960(statId.method_12836(), itemName);
        try {
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(itemId);
            if (item == null) {
                return false;
            }
            return item.method_19264() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isHostileMob(class_2960 statId) {
        String entityName;
        String path = statId.method_12832();
        if (path.startsWith("killed/")) {
            entityName = path.substring("killed/".length());
        } else if (path.startsWith("killed_by/")) {
            entityName = path.substring("killed_by/".length());
        } else {
            return false;
        }
        class_2960 entityId = new class_2960(statId.method_12836(), entityName);
        try {
            class_1299 entityType = (class_1299)class_7923.field_41177.method_10223(entityId);
            if (entityType == null) {
                return false;
            }
            class_1311 category = entityType.method_5891();
            return category == class_1311.field_6302;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static StatCategory findCategory(class_2960 statId) {
        for (StatCategory category : ORDERED_CATEGORIES) {
            if (!category.getFilter().test(statId)) continue;
            return category;
        }
        return CATEGORIES.get(GENERAL_ID);
    }
}

