/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3445;
import net.minecraft.class_3448;
import net.minecraft.class_3468;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import org.texboobcat.beautiful_statistics_screen.api.IconRenderer;
import org.texboobcat.beautiful_statistics_screen.api.StatCategory;
import org.texboobcat.beautiful_statistics_screen.api.StatEntry;
import org.texboobcat.beautiful_statistics_screen.client.hud.StatHudRenderer;
import org.texboobcat.beautiful_statistics_screen.client.render.EntityIconRenderer;
import org.texboobcat.beautiful_statistics_screen.config.ModConfig;
import org.texboobcat.beautiful_statistics_screen.core.StatCategoryRegistry;
import org.texboobcat.beautiful_statistics_screen.custom.CustomStatAdapter;

public class StatDataManager {
    private static final Map<class_2960, StatEntry> STAT_CACHE = new ConcurrentHashMap<class_2960, StatEntry>();
    private static final List<StatEntry> ALL_STATS = new ArrayList<StatEntry>();
    private static boolean initialized = false;
    private static long lastSyncRequestMs = 0L;
    private static final long SYNC_COOLDOWN_MS = 2000L;
    private static final long FAST_SYNC_COOLDOWN_MS = 250L;
    private static long lastDebugLogMs = 0L;
    private static final long DEBUG_LOG_INTERVAL_MS = 2000L;
    private static double lastPlayerX = 0.0;
    private static double lastPlayerY = 0.0;
    private static double lastPlayerZ = 0.0;
    private static boolean wasOnGround = false;
    private static boolean wasSprinting = false;
    private static boolean wasCrouching = false;
    private static boolean wasInWater = false;
    private static int ticksSinceLastSync = 0;

    public static synchronized void loadStats(class_746 player) {
        STAT_CACHE.clear();
        ALL_STATS.clear();
        initialized = false;
        if (player == null) {
            return;
        }
        class_2378 customStatRegistry = class_7923.field_41183;
        for (class_2960 statId : customStatRegistry) {
            class_3445 stat = class_3468.field_15419.method_14956((Object)statId);
            class_2960 id = new class_2960("minecraft", "custom/" + statId.method_12832());
            int value = player.method_3143().method_15025(stat);
            StatCategory category = StatCategoryRegistry.findCategory(id);
            class_5250 displayName = class_2561.method_43471((String)("stat.minecraft." + statId.method_12832()));
            class_5250 description = class_2561.method_43473();
            IconRenderer iconRenderer = StatDataManager.getCustomStatIcon(statId.method_12832());
            StatEntry entry = new StatEntry(id, category, value, (class_2561)displayName, (class_2561)description, iconRenderer);
            STAT_CACHE.put(id, entry);
            ALL_STATS.add(entry);
        }
        StatDataManager.loadItemStats(player, (class_3448<class_1792>)class_3468.field_15372, "used");
        StatDataManager.loadItemStats(player, (class_3448<class_1792>)class_3468.field_15370, "crafted");
        StatDataManager.loadItemStats(player, (class_3448<class_1792>)class_3468.field_15383, "broken");
        StatDataManager.loadItemStats(player, (class_3448<class_1792>)class_3468.field_15392, "picked_up");
        StatDataManager.loadItemStats(player, (class_3448<class_1792>)class_3468.field_15405, "dropped");
        StatDataManager.loadEntityStats(player, class_3468.field_15403, "killed", false);
        StatDataManager.loadEntityStats(player, class_3468.field_15411, "killed_by", true);
        StatDataManager.loadBlockStats(player, (class_3448<class_2248>)class_3468.field_15427, "mined");
        StatDataManager.loadCustomStats();
        lastPlayerX = 0.0;
        lastPlayerY = 0.0;
        lastPlayerZ = 0.0;
        wasOnGround = false;
        wasSprinting = false;
        wasCrouching = false;
        wasInWater = false;
        ticksSinceLastSync = 0;
        initialized = true;
    }

    private static void loadCustomStats() {
        List<StatEntry> customStatEntries = CustomStatAdapter.getCustomStatEntries();
        for (StatEntry entry : customStatEntries) {
            STAT_CACHE.put(entry.getStatId(), entry);
            ALL_STATS.add(entry);
        }
    }

    private static void loadItemStats(class_746 player, class_3448<class_1792> statType, String prefix) {
        for (class_1792 item : class_7923.field_41178) {
            class_3445 stat = statType.method_14956((Object)item);
            int value = player.method_3143().method_15025(stat);
            class_2960 itemId = class_7923.field_41178.method_10221((Object)item);
            class_2960 id = new class_2960(itemId.method_12836(), prefix + "/" + itemId.method_12832());
            StatCategory category = StatCategoryRegistry.findCategory(id);
            class_5250 displayName = class_2561.method_43471((String)("stat.beautiful_statistics_screen." + prefix)).method_27693(" ").method_10852(item.method_7848());
            class_5250 description = class_2561.method_43473();
            IconRenderer iconRenderer = (graphics, x, y, size) -> {
                class_1799 stack = new class_1799((class_1935)item);
                int offsetX = Math.max(0, (size - 16) / 2);
                int offsetY = Math.max(0, (size - 16) / 2);
                graphics.method_51427(stack, x + offsetX, y + offsetY);
            };
            StatEntry entry = new StatEntry(id, category, value, (class_2561)displayName, (class_2561)description, iconRenderer);
            STAT_CACHE.put(id, entry);
            ALL_STATS.add(entry);
        }
    }

    private static void loadEntityStats(class_746 player, class_3448<class_1299<?>> statType, String prefix, boolean isKilledBy) {
        for (class_1299 entityType : class_7923.field_41177) {
            class_3445 stat = statType.method_14956((Object)entityType);
            int value = player.method_3143().method_15025(stat);
            class_2960 entityId = class_7923.field_41177.method_10221((Object)entityType);
            class_2960 id = new class_2960(entityId.method_12836(), prefix + "/" + entityId.method_12832());
            StatCategory category = StatCategoryRegistry.findCategory(id);
            class_5250 displayName = class_2561.method_43471((String)("stat.beautiful_statistics_screen." + prefix)).method_27693(" ").method_10852(entityType.method_5897());
            class_5250 description = class_2561.method_43473();
            EntityIconRenderer iconRenderer = new EntityIconRenderer(entityType, isKilledBy);
            StatEntry entry = new StatEntry(id, category, value, (class_2561)displayName, (class_2561)description, iconRenderer);
            STAT_CACHE.put(id, entry);
            ALL_STATS.add(entry);
        }
    }

    private static void loadBlockStats(class_746 player, class_3448<class_2248> statType, String prefix) {
        for (class_2248 block : class_7923.field_41175) {
            class_3445 stat = statType.method_14956((Object)block);
            int value = player.method_3143().method_15025(stat);
            class_2960 blockId = class_7923.field_41175.method_10221((Object)block);
            class_2960 id = new class_2960(blockId.method_12836(), prefix + "/" + blockId.method_12832());
            StatCategory category = StatCategoryRegistry.findCategory(id);
            class_5250 displayName = class_2561.method_43471((String)("stat.beautiful_statistics_screen." + prefix)).method_27693(" ").method_10852((class_2561)block.method_9518());
            class_5250 description = class_2561.method_43473();
            IconRenderer iconRenderer = (graphics, x, y, size) -> {
                class_1799 stack = new class_1799((class_1935)block);
                int offsetX = Math.max(0, (size - 16) / 2);
                int offsetY = Math.max(0, (size - 16) / 2);
                graphics.method_51427(stack, x + offsetX, y + offsetY);
            };
            StatEntry entry = new StatEntry(id, category, value, (class_2561)displayName, (class_2561)description, iconRenderer);
            STAT_CACHE.put(id, entry);
            ALL_STATS.add(entry);
        }
    }

    private static String getStatPath(class_3445<?> stat) {
        String name = stat.method_1225();
        if (name == null) {
            return "unknown";
        }
        return name.toLowerCase().replace(" ", "_").replace(".", "_");
    }

    public static List<StatEntry> getAllStats() {
        return Collections.unmodifiableList(ALL_STATS);
    }

    public static List<StatEntry> getStatsByCategory(StatCategory category) {
        return ALL_STATS.stream().filter(entry -> entry.getCategory().equals(category)).collect(Collectors.toList());
    }

    public static List<StatEntry> searchStats(String query) {
        if (query == null || query.isEmpty()) {
            return StatDataManager.getAllStats();
        }
        return ALL_STATS.stream().filter(entry -> entry.matchesSearch(query)).collect(Collectors.toList());
    }

    public static List<StatEntry> getFilteredStats(StatCategory category, String query, boolean hideZero) {
        return ALL_STATS.stream().filter(entry -> category == null || entry.getCategory().equals(category)).filter(entry -> entry.matchesSearch(query)).filter(entry -> !hideZero || !entry.isZero()).collect(Collectors.toList());
    }

    public static StatEntry getStatEntry(class_2960 id) {
        return STAT_CACHE.get(id);
    }

    public static void refresh() {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            StatDataManager.requestServerSync();
            StatDataManager.loadStats(player);
            StatDataManager.resetClientTracking();
        }
    }

    public static void refreshPinned() {
        if (!initialized) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        StatDataManager.requestServerSyncFast();
        List<class_2960> pinnedStats = ModConfig.getPinnedStats();
        if (pinnedStats.isEmpty()) {
            return;
        }
        boolean anyChanged = false;
        boolean smoothing = ModConfig.getClient().enableSmoothStatUpdates || StatHudRenderer.isVisible();
        for (class_2960 statId : pinnedStats) {
            long existing;
            StatEntry entry = STAT_CACHE.get(statId);
            if (entry == null) continue;
            long current = StatDataManager.resolveCurrentValue(player, statId);
            long merged = smoothing ? Math.max(existing, current) : current;
            if (merged == (existing = entry.getValue())) continue;
            entry.setValue(merged);
            anyChanged = true;
        }
        if (anyChanged) {
            StatHudRenderer.invalidateLayoutCache();
        }
    }

    public static void updateClientSideStats() {
        if (!initialized) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        ++ticksSinceLastSync;
        List<class_2960> pinnedStats = ModConfig.getPinnedStats();
        if (pinnedStats.isEmpty()) {
            return;
        }
        double currentX = player.method_23317();
        double currentY = player.method_23318();
        double currentZ = player.method_23321();
        boolean isOnGround = player.method_24828();
        boolean isSprinting = player.method_5624();
        boolean isCrouching = player.method_18276();
        boolean isInWater = player.method_5799();
        if (lastPlayerX == 0.0 && lastPlayerY == 0.0 && lastPlayerZ == 0.0) {
            lastPlayerX = currentX;
            lastPlayerY = currentY;
            lastPlayerZ = currentZ;
            wasOnGround = isOnGround;
            wasSprinting = isSprinting;
            wasCrouching = isCrouching;
            wasInWater = isInWater;
            return;
        }
        double dx = currentX - lastPlayerX;
        double dy = currentY - lastPlayerY;
        double dz = currentZ - lastPlayerZ;
        double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
        long distanceCm = Math.round(horizontalDistance * 100.0);
        if (distanceCm > 0L) {
            if (isSprinting && isOnGround) {
                StatDataManager.incrementPinnedStat("minecraft:custom/sprint_one_cm", distanceCm, pinnedStats);
                StatDataManager.incrementPinnedStat("minecraft:custom/walk_one_cm", distanceCm, pinnedStats);
            } else if (isCrouching && isOnGround) {
                StatDataManager.incrementPinnedStat("minecraft:custom/crouch_one_cm", distanceCm, pinnedStats);
                StatDataManager.incrementPinnedStat("minecraft:custom/walk_one_cm", distanceCm, pinnedStats);
            } else if (isInWater) {
                if (player.method_5869()) {
                    StatDataManager.incrementPinnedStat("minecraft:custom/walk_under_water_one_cm", distanceCm, pinnedStats);
                }
                StatDataManager.incrementPinnedStat("minecraft:custom/swim_one_cm", distanceCm, pinnedStats);
            } else if (player.method_6101()) {
                StatDataManager.incrementPinnedStat("minecraft:custom/climb_one_cm", Math.round(Math.abs(dy) * 100.0), pinnedStats);
            } else if (!isOnGround && !wasOnGround) {
                if (dy < -0.1) {
                    StatDataManager.incrementPinnedStat("minecraft:custom/fall_one_cm", Math.round(Math.abs(dy) * 100.0), pinnedStats);
                } else if (player.method_31549().field_7479) {
                    StatDataManager.incrementPinnedStat("minecraft:custom/fly_one_cm", distanceCm, pinnedStats);
                }
            } else if (isOnGround) {
                StatDataManager.incrementPinnedStat("minecraft:custom/walk_one_cm", distanceCm, pinnedStats);
            }
        }
        StatDataManager.incrementPinnedStat("minecraft:custom/play_time", 1L, pinnedStats);
        StatDataManager.incrementPinnedStat("minecraft:custom/total_world_time", 1L, pinnedStats);
        StatDataManager.incrementPinnedStat("minecraft:custom/time_since_death", 1L, pinnedStats);
        StatDataManager.incrementPinnedStat("minecraft:custom/time_since_rest", 1L, pinnedStats);
        lastPlayerX = currentX;
        lastPlayerY = currentY;
        lastPlayerZ = currentZ;
        wasOnGround = isOnGround;
        wasSprinting = isSprinting;
        wasCrouching = isCrouching;
        wasInWater = isInWater;
    }

    private static void incrementPinnedStat(String statIdStr, long delta, List<class_2960> pinnedStats) {
        if (delta <= 0L) {
            return;
        }
        class_2960 statId = new class_2960(statIdStr);
        if (!pinnedStats.contains(statId)) {
            return;
        }
        StatEntry entry = STAT_CACHE.get(statId);
        if (entry != null) {
            entry.setValue(entry.getValue() + delta);
            StatHudRenderer.invalidateLayoutCache();
        }
    }

    public static void resetClientTracking() {
        ticksSinceLastSync = 0;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static void requestServerSync() {
        StatDataManager.requestServerSyncInternal(2000L);
    }

    public static void requestServerSyncFast() {
        StatDataManager.requestServerSyncInternal(250L);
    }

    private static void requestServerSyncInternal(long minDelayMs) {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.method_1562() == null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - lastSyncRequestMs < minDelayMs) {
            return;
        }
        lastSyncRequestMs = now;
        mc.method_1562().method_2883((class_2596)new class_2799(class_2799.class_2800.field_12775));
    }

    private static long resolveCurrentValue(class_746 player, class_2960 composedId) {
        String path = composedId.method_12832();
        String[] parts = path.split("/");
        if (parts.length != 2) {
            if (parts.length == 1) {
                try {
                    class_3445 stat = class_3468.field_15419.method_14956((Object)composedId);
                    if (stat != null) {
                        return player.method_3143().method_15025(stat);
                    }
                }
                catch (Exception stat) {
                    // empty catch block
                }
            }
            return 0L;
        }
        String type = parts[0];
        String target = parts[1];
        class_2960 targetId = new class_2960(composedId.method_12836(), target);
        try {
            switch (type) {
                case "used": {
                    class_1792 item = (class_1792)class_7923.field_41178.method_10223(targetId);
                    if (item == null) break;
                    class_3445 stat = class_3468.field_15372.method_14956((Object)item);
                    if (stat != null) {
                        return player.method_3143().method_15025(stat);
                    }
                    break;
                }
                case "crafted": {
                    class_1792 item = (class_1792)class_7923.field_41178.method_10223(targetId);
                    if (item == null) break;
                    class_3445 stat = class_3468.field_15370.method_14956((Object)item);
                    if (stat != null) {
                        return player.method_3143().method_15025(stat);
                    }
                    break;
                }
                case "broken": {
                    class_1792 item = (class_1792)class_7923.field_41178.method_10223(targetId);
                    if (item == null) break;
                    class_3445 stat = class_3468.field_15383.method_14956((Object)item);
                    if (stat != null) {
                        return player.method_3143().method_15025(stat);
                    }
                    break;
                }
                case "picked_up": {
                    class_1792 item = (class_1792)class_7923.field_41178.method_10223(targetId);
                    if (item == null) break;
                    class_3445 stat = class_3468.field_15392.method_14956((Object)item);
                    if (stat != null) {
                        return player.method_3143().method_15025(stat);
                    }
                    break;
                }
                case "dropped": {
                    class_1792 item = (class_1792)class_7923.field_41178.method_10223(targetId);
                    if (item == null) break;
                    class_3445 stat = class_3468.field_15405.method_14956((Object)item);
                    if (stat != null) {
                        return player.method_3143().method_15025(stat);
                    }
                    break;
                }
                case "mined": {
                    class_2248 block = (class_2248)class_7923.field_41175.method_10223(targetId);
                    if (block == null) break;
                    class_3445 stat = class_3468.field_15427.method_14956((Object)block);
                    if (stat != null) {
                        return player.method_3143().method_15025(stat);
                    }
                    break;
                }
                case "killed": {
                    class_1299 entityType = (class_1299)class_7923.field_41177.method_10223(targetId);
                    if (entityType == null) break;
                    class_3445 stat = class_3468.field_15403.method_14956((Object)entityType);
                    if (stat != null) {
                        return player.method_3143().method_15025(stat);
                    }
                    break;
                }
                case "killed_by": {
                    class_1299 entityType = (class_1299)class_7923.field_41177.method_10223(targetId);
                    if (entityType == null) break;
                    class_3445 stat = class_3468.field_15411.method_14956((Object)entityType);
                    if (stat != null) {
                        return player.method_3143().method_15025(stat);
                    }
                    break;
                }
                case "custom": {
                    class_3445 stat = class_3468.field_15419.method_14956((Object)targetId);
                    if (stat == null) break;
                    return player.method_3143().method_15025(stat);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }

    private static IconRenderer getCustomStatIcon(String statPath) {
        class_1792 iconItem = switch (statPath) {
            case "play_time", "play_one_minute", "total_world_time" -> class_1802.field_8557;
            case "time_since_death" -> class_1802.field_8288;
            case "time_since_rest" -> class_1802.field_8789;
            case "sneak_time" -> class_1802.field_8370;
            case "walk_one_cm", "walk_on_water_one_cm", "walk_under_water_one_cm" -> class_1802.field_8660;
            case "sprint_one_cm" -> class_1802.field_8753;
            case "crouch_one_cm" -> class_1802.field_8370;
            case "fly_one_cm" -> class_1802.field_8833;
            case "fall_one_cm" -> class_1802.field_8153;
            case "climb_one_cm" -> class_1802.field_8121;
            case "swim_one_cm" -> class_1802.field_8090;
            case "boat_one_cm" -> class_1802.field_8533;
            case "minecart_one_cm" -> class_1802.field_8045;
            case "horse_one_cm" -> class_1802.field_8175;
            case "pig_one_cm" -> class_1802.field_8184;
            case "aviate_one_cm" -> class_1802.field_8833;
            case "strider_one_cm" -> class_1802.field_23254;
            case "damage_dealt", "damage_dealt_absorbed", "damage_dealt_resisted" -> class_1802.field_8802;
            case "damage_taken" -> class_1802.field_8255;
            case "damage_blocked_by_shield" -> class_1802.field_8255;
            case "damage_absorbed" -> class_1802.field_8463;
            case "damage_resisted" -> class_1802.field_22028;
            case "mob_kills" -> class_1802.field_8371;
            case "deaths" -> class_1802.field_8398;
            case "player_kills" -> class_1802.field_8802;
            case "jump" -> class_1802.field_8073;
            case "leave_game" -> class_1802.field_8077;
            case "open_chest" -> class_1802.field_8106;
            case "open_enderchest" -> class_1802.field_8466;
            case "open_shulker_box" -> class_1802.field_8545;
            case "open_barrel" -> class_1802.field_16307;
            case "inspect_hopper" -> class_1802.field_8239;
            case "inspect_dispenser" -> class_1802.field_8357;
            case "inspect_dropper" -> class_1802.field_8878;
            case "play_noteblock" -> class_1802.field_8643;
            case "tune_noteblock" -> class_1802.field_8643;
            case "pot_flower" -> class_1802.field_8074;
            case "trigger_trapped_chest" -> class_1802.field_8247;
            case "play_record" -> class_1802.field_8075;
            case "interact_with_furnace" -> class_1802.field_8732;
            case "interact_with_blast_furnace" -> class_1802.field_16306;
            case "interact_with_smoker" -> class_1802.field_16309;
            case "interact_with_lectern" -> class_1802.field_16312;
            case "interact_with_campfire" -> class_1802.field_17346;
            case "interact_with_cartography_table" -> class_1802.field_16313;
            case "interact_with_loom" -> class_1802.field_8772;
            case "interact_with_stonecutter" -> class_1802.field_16305;
            case "interact_with_beacon" -> class_1802.field_8668;
            case "interact_with_brewingstand" -> class_1802.field_8740;
            case "interact_with_crafting_table" -> class_1802.field_8465;
            case "interact_with_anvil" -> class_1802.field_8782;
            case "interact_with_grindstone" -> class_1802.field_16311;
            case "interact_with_smithing_table" -> class_1802.field_16308;
            case "animals_bred" -> class_1802.field_8861;
            case "fish_caught" -> class_1802.field_8378;
            case "talked_to_villager" -> class_1802.field_8687;
            case "traded_with_villager" -> class_1802.field_8687;
            case "eat_cake_slice" -> class_1802.field_17534;
            case "fill_cauldron" -> class_1802.field_8638;
            case "use_cauldron" -> class_1802.field_8638;
            case "clean_armor" -> class_1802.field_8705;
            case "clean_banner" -> class_1802.field_8539;
            case "clean_shulker_box" -> class_1802.field_8545;
            case "drop" -> class_1802.field_8878;
            case "enchant_item" -> class_1802.field_8657;
            case "bell_ring" -> class_1802.field_16315;
            case "raid_trigger" -> class_1802.field_16315;
            case "raid_win" -> class_1802.field_8288;
            case "target_hit" -> class_1802.field_22420;
            default -> class_1802.field_8407;
        };
        return (graphics, x, y, size) -> {
            class_1799 stack = new class_1799((class_1935)iconItem);
            int offsetX = Math.max(0, (size - 16) / 2);
            int offsetY = Math.max(0, (size - 16) / 2);
            graphics.method_51427(stack, x + offsetX, y + offsetY);
        };
    }
}

