/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.custom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.texboobcat.beautiful_statistics_screen.api.IconRenderer;
import org.texboobcat.beautiful_statistics_screen.api.StatCategory;
import org.texboobcat.beautiful_statistics_screen.api.StatEntry;
import org.texboobcat.beautiful_statistics_screen.core.StatCategoryRegistry;
import org.texboobcat.beautiful_statistics_screen.custom.CustomStatDefinition;
import org.texboobcat.beautiful_statistics_screen.custom.CustomStatManager;

public class CustomStatAdapter {
    public static List<StatEntry> getCustomStatEntries() {
        ArrayList<StatEntry> entries = new ArrayList<StatEntry>();
        Collection<CustomStatDefinition> customStats = CustomStatManager.getAllCustomStats();
        for (CustomStatDefinition customStat : customStats) {
            if (!customStat.isEnabled()) continue;
            class_2960 statId = new class_2960("beautiful_statistics_screen", "custom_stat/" + customStat.getId());
            StatCategory category = StatCategoryRegistry.getCategory(StatCategoryRegistry.CUSTOM_ID);
            IconRenderer iconRenderer = CustomStatAdapter.createIconRenderer(customStat.getIcon());
            StatEntry entry = new StatEntry(statId, category, customStat.getCurrentValue(), (class_2561)class_2561.method_43470((String)customStat.getName()), (class_2561)class_2561.method_43470((String)(customStat.getDescription() != null ? customStat.getDescription() : "")), iconRenderer);
            entries.add(entry);
        }
        return entries;
    }

    public static StatEntry getCustomStatEntry(String customStatId) {
        CustomStatDefinition customStat = CustomStatManager.getCustomStat(customStatId);
        if (customStat == null) {
            return null;
        }
        class_2960 statId = new class_2960("beautiful_statistics_screen", "custom_stat/" + customStat.getId());
        StatCategory category = StatCategoryRegistry.getCategory(StatCategoryRegistry.CUSTOM_ID);
        IconRenderer iconRenderer = CustomStatAdapter.createIconRenderer(customStat.getIcon());
        return new StatEntry(statId, category, customStat.getCurrentValue(), (class_2561)class_2561.method_43470((String)customStat.getName()), (class_2561)class_2561.method_43470((String)(customStat.getDescription() != null ? customStat.getDescription() : "")), iconRenderer);
    }

    public static boolean isCustomStat(class_2960 statId) {
        return statId.method_12836().equals("beautiful_statistics_screen") && statId.method_12832().startsWith("custom_stat/");
    }

    public static String extractCustomStatId(class_2960 statId) {
        if (!CustomStatAdapter.isCustomStat(statId)) {
            return null;
        }
        return statId.method_12832().substring("custom_stat/".length());
    }

    private static IconRenderer createIconRenderer(String iconString) {
        if (iconString == null || iconString.isEmpty()) {
            return IconRenderer.EMPTY;
        }
        try {
            class_2960 iconId = new class_2960(iconString);
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(iconId);
            if (item == null || item == class_1802.field_8162) {
                return IconRenderer.EMPTY;
            }
            return (graphics, x, y, size) -> {
                class_1799 stack = new class_1799((class_1935)item);
                int offsetX = Math.max(0, (size - 16) / 2);
                int offsetY = Math.max(0, (size - 16) / 2);
                graphics.method_51427(stack, x + offsetX, y + offsetY);
            };
        }
        catch (Exception e) {
            return IconRenderer.EMPTY;
        }
    }
}

