/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.custom;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.texboobcat.beautiful_statistics_screen.custom.CustomStatDefinition;
import org.texboobcat.beautiful_statistics_screen.custom.CustomStatManager;

public class CustomStatTracker {
    public static void onBlockMined(class_2248 block, int count) {
        class_2960 blockId = class_7923.field_41175.method_10221((Object)block);
        CustomStatTracker.trackEvent(CustomStatDefinition.TrackingType.BLOCK_MINED, blockId.toString(), count);
    }

    public static void onBlockPlaced(class_2248 block, int count) {
        class_2960 blockId = class_7923.field_41175.method_10221((Object)block);
        CustomStatTracker.trackEvent(CustomStatDefinition.TrackingType.BLOCK_PLACED, blockId.toString(), count);
    }

    public static void onItemUsed(class_1792 item, int count) {
        class_2960 itemId = class_7923.field_41178.method_10221((Object)item);
        CustomStatTracker.trackEvent(CustomStatDefinition.TrackingType.ITEM_USED, itemId.toString(), count);
    }

    public static void onItemCrafted(class_1792 item, int count) {
        class_2960 itemId = class_7923.field_41178.method_10221((Object)item);
        CustomStatTracker.trackEvent(CustomStatDefinition.TrackingType.ITEM_CRAFTED, itemId.toString(), count);
    }

    public static void onItemPickedUp(class_1792 item, int count) {
        class_2960 itemId = class_7923.field_41178.method_10221((Object)item);
        CustomStatTracker.trackEvent(CustomStatDefinition.TrackingType.ITEM_PICKED_UP, itemId.toString(), count);
    }

    public static void onItemDropped(class_1792 item, int count) {
        class_2960 itemId = class_7923.field_41178.method_10221((Object)item);
        CustomStatTracker.trackEvent(CustomStatDefinition.TrackingType.ITEM_DROPPED, itemId.toString(), count);
    }

    public static void onEntityKilled(class_1297 entity) {
        class_2960 entityId = class_7923.field_41177.method_10221((Object)entity.method_5864());
        CustomStatTracker.trackEvent(CustomStatDefinition.TrackingType.ENTITY_KILLED, entityId.toString(), 1L);
    }

    public static void onEntityBred(class_1297 entity) {
        class_2960 entityId = class_7923.field_41177.method_10221((Object)entity.method_5864());
        CustomStatTracker.trackEvent(CustomStatDefinition.TrackingType.ENTITY_BRED, entityId.toString(), 1L);
    }

    public static void onDamageDealt(float amount, class_1297 target) {
        class_2960 targetId = target != null ? class_7923.field_41177.method_10221((Object)target.method_5864()) : new class_2960("minecraft", "unknown");
        CustomStatTracker.trackEvent(CustomStatDefinition.TrackingType.DAMAGE_DEALT, targetId.toString(), Math.round(amount * 10.0f));
    }

    public static void onDamageTaken(float amount, class_1297 source) {
        class_2960 sourceId = source != null ? class_7923.field_41177.method_10221((Object)source.method_5864()) : new class_2960("minecraft", "unknown");
        CustomStatTracker.trackEvent(CustomStatDefinition.TrackingType.DAMAGE_TAKEN, sourceId.toString(), Math.round(amount * 10.0f));
    }

    public static void onDistanceTraveled(String movementType, long distanceCm) {
        CustomStatTracker.trackEvent(CustomStatDefinition.TrackingType.DISTANCE_TRAVELED, movementType, distanceCm);
    }

    public static void onTick() {
        List<CustomStatDefinition> timeStats = CustomStatManager.getMatchingStats(CustomStatDefinition.TrackingType.TIME_ELAPSED, "*");
        for (CustomStatDefinition stat : timeStats) {
            if (!CustomStatManager.checkConditions(stat)) continue;
            CustomStatManager.incrementStat(stat.getId(), 1L);
        }
    }

    public static void trackCustomEvent(String eventName, long amount) {
        CustomStatTracker.trackEvent(CustomStatDefinition.TrackingType.CUSTOM_EVENT, eventName, amount);
    }

    private static void trackEvent(CustomStatDefinition.TrackingType trackingType, String targetId, long amount) {
        if (!CustomStatManager.isInitialized()) {
            return;
        }
        List<CustomStatDefinition> matchingStats = CustomStatManager.getMatchingStats(trackingType, targetId);
        for (CustomStatDefinition stat : matchingStats) {
            if (!CustomStatManager.checkConditions(stat)) continue;
            switch (stat.getAggregationType()) {
                case SUM: 
                case INDIVIDUAL: {
                    CustomStatManager.incrementStat(stat.getId(), amount);
                    break;
                }
                case AVERAGE: {
                    CustomStatManager.incrementStat(stat.getId(), amount);
                    break;
                }
                case MAX: {
                    if (amount <= stat.getCurrentValue()) break;
                    stat.increment(amount - stat.getCurrentValue());
                    break;
                }
                case MIN: {
                    if (stat.getCurrentValue() != 0L && amount >= stat.getCurrentValue()) break;
                    stat.reset();
                    stat.increment(amount);
                }
            }
        }
    }

    public static void trackItemStack(CustomStatDefinition.TrackingType trackingType, class_1799 stack) {
        if (stack.method_7960()) {
            return;
        }
        class_2960 itemId = class_7923.field_41178.method_10221((Object)stack.method_7909());
        CustomStatTracker.trackEvent(trackingType, itemId.toString(), stack.method_7947());
    }
}

