/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.custom;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import org.texboobcat.beautiful_statistics_screen.custom.CustomStatDefinition;
import org.texboobcat.beautiful_statistics_screen.custom.StatGoal;

public class StatNotificationManager {
    private static final Queue<StatNotification> pendingNotifications = new ConcurrentLinkedQueue<StatNotification>();
    private static StatNotification currentNotification = null;
    private static long notificationStartTime = 0L;
    private static final long NOTIFICATION_DURATION = 5000L;

    public static void notifyGoalAchieved(CustomStatDefinition stat, StatGoal goal) {
        if (!goal.shouldShowNotification()) {
            return;
        }
        StatNotification notification = new StatNotification(stat, goal);
        pendingNotifications.offer(notification);
        if (goal.shouldPlaySound()) {
            StatNotificationManager.playAchievementSound();
        }
    }

    public static void tick() {
        long now = System.currentTimeMillis();
        if (currentNotification != null && now - notificationStartTime >= 5000L) {
            currentNotification = null;
        }
        if (currentNotification == null && !pendingNotifications.isEmpty()) {
            currentNotification = pendingNotifications.poll();
            notificationStartTime = now;
        }
    }

    public static StatNotification getCurrentNotification() {
        return currentNotification;
    }

    public static float getNotificationProgress() {
        if (currentNotification == null) {
            return 0.0f;
        }
        long elapsed = System.currentTimeMillis() - notificationStartTime;
        float progress = (float)elapsed / 5000.0f;
        if (progress < 0.1f) {
            return progress / 0.1f;
        }
        if (progress > 0.9f) {
            return (1.0f - progress) / 0.1f;
        }
        return 1.0f;
    }

    public static void clearCurrentNotification() {
        currentNotification = null;
    }

    public static void clearAll() {
        pendingNotifications.clear();
        currentNotification = null;
    }

    private static void playAchievementSound() {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 != null && mc.field_1687 != null) {
            mc.field_1687.method_8486(mc.field_1724.method_23317(), mc.field_1724.method_23318(), mc.field_1724.method_23321(), class_3417.field_14709, class_3419.field_15248, 0.5f, 1.0f, false);
        }
    }

    public static void sendChatMessage(CustomStatDefinition stat, StatGoal goal) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 != null) {
            class_5250 message = class_2561.method_43470((String)"\u00a76[Custom Stats] ").method_10852((class_2561)class_2561.method_43470((String)("\u00a7eAchieved: \u00a7f" + goal.getName()))).method_10852((class_2561)class_2561.method_43470((String)(" \u00a77(" + stat.getName() + ")")));
            mc.field_1724.method_43496((class_2561)message);
            if (goal.getRewardMessage() != null && !goal.getRewardMessage().isEmpty()) {
                mc.field_1724.method_43496((class_2561)class_2561.method_43470((String)("\u00a7a" + goal.getRewardMessage())));
            }
        }
    }

    public static int getPendingCount() {
        return pendingNotifications.size();
    }

    public static boolean hasActiveNotification() {
        return currentNotification != null;
    }

    public static class StatNotification {
        private final CustomStatDefinition stat;
        private final StatGoal goal;
        private final long timestamp;

        public StatNotification(CustomStatDefinition stat, StatGoal goal) {
            this.stat = stat;
            this.goal = goal;
            this.timestamp = System.currentTimeMillis();
        }

        public CustomStatDefinition getStat() {
            return this.stat;
        }

        public StatGoal getGoal() {
            return this.goal;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public class_2561 getTitle() {
            return class_2561.method_43470((String)"\u00a76\u00a7l\u2b50 Goal Achieved!");
        }

        public class_2561 getMessage() {
            if (this.goal.getTimesAchieved() > 1) {
                return class_2561.method_43470((String)("\u00a7e" + this.goal.getName() + " \u00a77(x" + this.goal.getTimesAchieved() + ")")).method_27693("\n\u00a77" + this.stat.getName());
            }
            return class_2561.method_43470((String)("\u00a7e" + this.goal.getName())).method_27693("\n\u00a77" + this.stat.getName());
        }

        public class_2561 getRewardMessage() {
            String reward = this.goal.getRewardMessage();
            if (reward != null && !reward.isEmpty()) {
                return class_2561.method_43470((String)("\u00a7a" + reward));
            }
            return class_2561.method_43473();
        }
    }
}

