/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.custom.conditions;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.LogicMode;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.StatCondition;

public class ConditionGroup {
    @SerializedName(value="logic")
    private LogicMode logicMode = LogicMode.AND;
    @SerializedName(value="conditions")
    private List<StatCondition> conditions = new ArrayList<StatCondition>();

    public ConditionGroup() {
    }

    public ConditionGroup(LogicMode logicMode) {
        this.logicMode = logicMode;
    }

    public void addCondition(StatCondition condition) {
        this.conditions.add(condition);
    }

    public void removeCondition(int index) {
        if (index >= 0 && index < this.conditions.size()) {
            this.conditions.remove(index);
        }
    }

    public LogicMode getLogicMode() {
        return this.logicMode;
    }

    public void setLogicMode(LogicMode logicMode) {
        this.logicMode = logicMode;
    }

    public List<StatCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<StatCondition> conditions) {
        this.conditions = conditions;
    }

    public boolean isEmpty() {
        return this.conditions == null || this.conditions.isEmpty();
    }

    public String toString() {
        if (this.isEmpty()) {
            return "No conditions";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (i > 0) {
                sb.append(" ").append(this.logicMode.name()).append(" ");
            }
            sb.append(this.conditions.get(i).toString());
        }
        return sb.toString();
    }
}

