/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.custom.conditions;

import org.texboobcat.beautiful_statistics_screen.custom.conditions.ComparisonOperator;

public enum ConditionType {
    BIOME("Biome", "minecraft:plains", "Check current biome"),
    DIMENSION("Dimension", "minecraft:overworld", "Check current dimension"),
    Y_LEVEL("Y Level", "64", "Check Y coordinate"),
    LIGHT_LEVEL("Light Level", "15", "Check light level at position"),
    WEATHER("Weather", "rain", "Check weather (clear/rain/thunder)"),
    TIME_OF_DAY("Time of Day", "day", "Check time (morning/day/evening/night)"),
    BLOCK_BELOW("Block Below", "minecraft:grass_block", "Check block beneath player"),
    GAME_MODE("Game Mode", "survival", "Check game mode"),
    HEALTH("Health", "10.0", "Check player health"),
    HUNGER("Hunger", "10", "Check hunger level"),
    EXPERIENCE_LEVEL("Experience Level", "30", "Check XP level"),
    ON_GROUND("On Ground", "true", "Check if on ground"),
    IN_WATER("In Water", "true", "Check if in water"),
    IN_LAVA("In Lava", "false", "Check if in lava"),
    ITEM_IN_HAND("Item in Hand", "minecraft:diamond_pickaxe", "Check held item"),
    ITEM_TAG("Item Tag", "#minecraft:pickaxes", "Check if item has tag"),
    EFFECT("Has Effect", "minecraft:speed", "Check active potion effect"),
    CUSTOM_TAG("Custom NBT Tag", "custom.tag", "Check custom NBT data");

    private final String displayName;
    private final String exampleValue;
    private final String description;

    private ConditionType(String displayName, String exampleValue, String description) {
        this.displayName = displayName;
        this.exampleValue = exampleValue;
        this.description = description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getExampleValue() {
        return this.exampleValue;
    }

    public String getDescription() {
        return this.description;
    }

    public ComparisonOperator[] getValidOperators() {
        ComparisonOperator[] comparisonOperatorArray;
        switch (this.ordinal()) {
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: {
                ComparisonOperator[] comparisonOperatorArray2 = new ComparisonOperator[6];
                comparisonOperatorArray2[0] = ComparisonOperator.EQUALS;
                comparisonOperatorArray2[1] = ComparisonOperator.NOT_EQUALS;
                comparisonOperatorArray2[2] = ComparisonOperator.GREATER_THAN;
                comparisonOperatorArray2[3] = ComparisonOperator.LESS_THAN;
                comparisonOperatorArray2[4] = ComparisonOperator.GREATER_OR_EQUAL;
                comparisonOperatorArray = comparisonOperatorArray2;
                comparisonOperatorArray2[5] = ComparisonOperator.LESS_OR_EQUAL;
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                ComparisonOperator[] comparisonOperatorArray3 = new ComparisonOperator[2];
                comparisonOperatorArray3[0] = ComparisonOperator.EQUALS;
                comparisonOperatorArray = comparisonOperatorArray3;
                comparisonOperatorArray3[1] = ComparisonOperator.NOT_EQUALS;
                break;
            }
            case 0: 
            case 1: 
            case 6: 
            case 14: {
                ComparisonOperator[] comparisonOperatorArray4 = new ComparisonOperator[6];
                comparisonOperatorArray4[0] = ComparisonOperator.EQUALS;
                comparisonOperatorArray4[1] = ComparisonOperator.NOT_EQUALS;
                comparisonOperatorArray4[2] = ComparisonOperator.CONTAINS;
                comparisonOperatorArray4[3] = ComparisonOperator.STARTS_WITH;
                comparisonOperatorArray4[4] = ComparisonOperator.ENDS_WITH;
                comparisonOperatorArray = comparisonOperatorArray4;
                comparisonOperatorArray4[5] = ComparisonOperator.MATCHES_REGEX;
                break;
            }
            default: {
                ComparisonOperator[] comparisonOperatorArray5 = new ComparisonOperator[3];
                comparisonOperatorArray5[0] = ComparisonOperator.EQUALS;
                comparisonOperatorArray5[1] = ComparisonOperator.NOT_EQUALS;
                comparisonOperatorArray = comparisonOperatorArray5;
                comparisonOperatorArray5[2] = ComparisonOperator.CONTAINS;
            }
        }
        return comparisonOperatorArray;
    }
}

