/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.custom.conditions;

import com.google.gson.annotations.SerializedName;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ComparisonOperator;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ConditionType;

public class StatCondition {
    @SerializedName(value="type")
    private ConditionType type;
    @SerializedName(value="operator")
    private ComparisonOperator operator;
    @SerializedName(value="value")
    private String value;
    @SerializedName(value="negated")
    private boolean negated = false;

    public StatCondition() {
        this.type = ConditionType.BIOME;
        this.operator = ComparisonOperator.EQUALS;
        this.value = "";
    }

    public StatCondition(ConditionType type, ComparisonOperator operator, String value) {
        this.type = type;
        this.operator = operator;
        this.value = value;
        this.negated = false;
    }

    public StatCondition(ConditionType type, ComparisonOperator operator, String value, boolean negated) {
        this.type = type;
        this.operator = operator;
        this.value = value;
        this.negated = negated;
    }

    public ConditionType getType() {
        return this.type;
    }

    public ComparisonOperator getOperator() {
        return this.operator;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public void setType(ConditionType type) {
        this.type = type;
    }

    public void setOperator(ComparisonOperator operator) {
        this.operator = operator;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setNegated(boolean negated) {
        this.negated = negated;
    }

    public String toString() {
        String prefix = this.negated ? "NOT " : "";
        return prefix + this.type.getDisplayName() + " " + this.operator.getSymbol() + " " + this.value;
    }
}

