/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.custom.conditions;

import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7924;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ComparisonOperator;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.ConditionGroup;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.LogicMode;
import org.texboobcat.beautiful_statistics_screen.custom.conditions.StatCondition;

public class StatConditionEvaluator {
    public static boolean evaluate(ConditionGroup group, class_746 player) {
        if (group == null || group.getConditions().isEmpty()) {
            return true;
        }
        boolean result = group.getLogicMode() == LogicMode.AND;
        for (StatCondition condition : group.getConditions()) {
            boolean conditionResult = StatConditionEvaluator.evaluateSingle(condition, player);
            if (group.getLogicMode() == LogicMode.AND) {
                if (result = result && conditionResult) continue;
                return false;
            }
            if (!(result = result || conditionResult)) continue;
            return true;
        }
        return result;
    }

    public static boolean evaluateSingle(StatCondition condition, class_746 player) {
        if (player == null || player.method_37908() == null) {
            return false;
        }
        try {
            boolean result;
            switch (condition.getType()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case BIOME: {
                    boolean bl = StatConditionEvaluator.checkBiome(condition, player);
                    break;
                }
                case DIMENSION: {
                    boolean bl = StatConditionEvaluator.checkDimension(condition, player);
                    break;
                }
                case Y_LEVEL: {
                    boolean bl = StatConditionEvaluator.checkYLevel(condition, player);
                    break;
                }
                case LIGHT_LEVEL: {
                    boolean bl = StatConditionEvaluator.checkLightLevel(condition, player);
                    break;
                }
                case WEATHER: {
                    boolean bl = StatConditionEvaluator.checkWeather(condition, player);
                    break;
                }
                case TIME_OF_DAY: {
                    boolean bl = StatConditionEvaluator.checkTimeOfDay(condition, player);
                    break;
                }
                case GAME_MODE: {
                    boolean bl = StatConditionEvaluator.checkGameMode(condition, player);
                    break;
                }
                case EFFECT: {
                    boolean bl = StatConditionEvaluator.checkEffect(condition, player);
                    break;
                }
                case ITEM_IN_HAND: {
                    boolean bl = StatConditionEvaluator.checkItemInHand(condition, player);
                    break;
                }
                case ITEM_TAG: {
                    boolean bl = StatConditionEvaluator.checkItemTag(condition, player);
                    break;
                }
                case BLOCK_BELOW: {
                    boolean bl = StatConditionEvaluator.checkBlockBelow(condition, player);
                    break;
                }
                case ON_GROUND: {
                    boolean bl = StatConditionEvaluator.checkOnGround(condition, player);
                    break;
                }
                case IN_WATER: {
                    boolean bl = StatConditionEvaluator.checkInWater(condition, player);
                    break;
                }
                case IN_LAVA: {
                    boolean bl = StatConditionEvaluator.checkInLava(condition, player);
                    break;
                }
                case HEALTH: {
                    boolean bl = StatConditionEvaluator.checkHealth(condition, player);
                    break;
                }
                case HUNGER: {
                    boolean bl = StatConditionEvaluator.checkHunger(condition, player);
                    break;
                }
                case EXPERIENCE_LEVEL: {
                    boolean bl = StatConditionEvaluator.checkExperienceLevel(condition, player);
                    break;
                }
                case CUSTOM_TAG: {
                    boolean bl = result = StatConditionEvaluator.checkCustomTag(condition, player);
                }
            }
            return condition.isNegated() ? !result : result;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean checkBiome(StatCondition condition, class_746 player) {
        class_2338 pos = player.method_24515();
        class_6880 biomeHolder = player.method_37908().method_23753(pos);
        class_2960 biomeId = biomeHolder.method_40230().map(class_5321::method_29177).orElse(null);
        if (biomeId != null) {
            return StatConditionEvaluator.compareString(biomeId.toString(), condition.getValue(), condition.getOperator());
        }
        return false;
    }

    private static boolean checkDimension(StatCondition condition, class_746 player) {
        class_2960 dimensionId = player.method_37908().method_27983().method_29177();
        return StatConditionEvaluator.compareString(dimensionId.toString(), condition.getValue(), condition.getOperator());
    }

    private static boolean checkYLevel(StatCondition condition, class_746 player) {
        int yLevel = player.method_24515().method_10264();
        return StatConditionEvaluator.compareNumeric(yLevel, condition.getValue(), condition.getOperator());
    }

    private static boolean checkLightLevel(StatCondition condition, class_746 player) {
        class_2338 pos = player.method_24515();
        int lightLevel = player.method_37908().method_22339(pos);
        return StatConditionEvaluator.compareNumeric(lightLevel, condition.getValue(), condition.getOperator());
    }

    private static boolean checkWeather(StatCondition condition, class_746 player) {
        class_1937 level = player.method_37908();
        String weather = level.method_8419() ? (level.method_8546() ? "thunder" : "rain") : "clear";
        return StatConditionEvaluator.compareString(weather, condition.getValue(), condition.getOperator());
    }

    private static boolean checkTimeOfDay(StatCondition condition, class_746 player) {
        long time = player.method_37908().method_8532() % 24000L;
        String timeOfDay = time >= 0L && time < 6000L ? "morning" : (time >= 6000L && time < 12000L ? "day" : (time >= 12000L && time < 18000L ? "evening" : "night"));
        return StatConditionEvaluator.compareString(timeOfDay, condition.getValue(), condition.getOperator());
    }

    private static boolean checkGameMode(StatCondition condition, class_746 player) {
        String gameMode = player.method_31549().field_7477 ? "creative" : (player.method_7325() ? "spectator" : "survival");
        return StatConditionEvaluator.compareString(gameMode, condition.getValue(), condition.getOperator());
    }

    private static boolean checkEffect(StatCondition condition, class_746 player) {
        String effectId = condition.getValue();
        class_2960 effectLoc = class_2960.method_12829((String)effectId);
        if (effectLoc == null) {
            return false;
        }
        return player.method_6026().stream().anyMatch(effect -> {
            class_2960 id = player.method_37908().method_30349().method_30530(class_7924.field_41208).method_10221((Object)effect.method_5579());
            return id != null && id.equals((Object)effectLoc);
        });
    }

    private static boolean checkItemInHand(StatCondition condition, class_746 player) {
        class_1799 mainHand = player.method_6047();
        class_1799 offHand = player.method_6079();
        String itemId = condition.getValue();
        boolean mainHandMatch = StatConditionEvaluator.checkItemMatch(mainHand, itemId, condition.getOperator());
        boolean offHandMatch = StatConditionEvaluator.checkItemMatch(offHand, itemId, condition.getOperator());
        return mainHandMatch || offHandMatch;
    }

    private static boolean checkItemTag(StatCondition condition, class_746 player) {
        class_1799 mainHand = player.method_6047();
        class_1799 offHand = player.method_6079();
        String tagId = condition.getValue();
        class_2960 tagLoc = class_2960.method_12829((String)tagId);
        if (tagLoc == null) {
            return false;
        }
        class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)tagLoc);
        return mainHand.method_31573(tag) || offHand.method_31573(tag);
    }

    private static boolean checkBlockBelow(StatCondition condition, class_746 player) {
        class_2338 belowPos = player.method_24515().method_10074();
        class_2960 blockId = player.method_37908().method_30349().method_30530(class_7924.field_41254).method_10221((Object)player.method_37908().method_8320(belowPos).method_26204());
        if (blockId == null) {
            return false;
        }
        return StatConditionEvaluator.compareString(blockId.toString(), condition.getValue(), condition.getOperator());
    }

    private static boolean checkOnGround(StatCondition condition, class_746 player) {
        boolean expectedOnGround;
        boolean onGround = player.method_24828();
        return onGround == (expectedOnGround = Boolean.parseBoolean(condition.getValue()));
    }

    private static boolean checkInWater(StatCondition condition, class_746 player) {
        boolean expectedInWater;
        boolean inWater = player.method_5799();
        return inWater == (expectedInWater = Boolean.parseBoolean(condition.getValue()));
    }

    private static boolean checkInLava(StatCondition condition, class_746 player) {
        boolean expectedInLava;
        boolean inLava = player.method_5771();
        return inLava == (expectedInLava = Boolean.parseBoolean(condition.getValue()));
    }

    private static boolean checkHealth(StatCondition condition, class_746 player) {
        float health = player.method_6032();
        return StatConditionEvaluator.compareNumeric(health, condition.getValue(), condition.getOperator());
    }

    private static boolean checkHunger(StatCondition condition, class_746 player) {
        int hunger = player.method_7344().method_7586();
        return StatConditionEvaluator.compareNumeric(hunger, condition.getValue(), condition.getOperator());
    }

    private static boolean checkExperienceLevel(StatCondition condition, class_746 player) {
        int level = player.field_7520;
        return StatConditionEvaluator.compareNumeric(level, condition.getValue(), condition.getOperator());
    }

    private static boolean checkCustomTag(StatCondition condition, class_746 player) {
        return false;
    }

    private static boolean checkItemMatch(class_1799 stack, String itemId, ComparisonOperator operator) {
        if (stack.method_7960()) {
            return false;
        }
        class_2960 stackId = stack.method_7909().method_40131().method_40237().method_29177();
        return StatConditionEvaluator.compareString(stackId.toString(), itemId, operator);
    }

    private static boolean compareString(String actual, String expected, ComparisonOperator operator) {
        return switch (operator) {
            case ComparisonOperator.EQUALS -> actual.equals(expected);
            case ComparisonOperator.NOT_EQUALS -> {
                if (!actual.equals(expected)) {
                    yield true;
                }
                yield false;
            }
            case ComparisonOperator.CONTAINS -> actual.contains(expected);
            case ComparisonOperator.STARTS_WITH -> actual.startsWith(expected);
            case ComparisonOperator.ENDS_WITH -> actual.endsWith(expected);
            case ComparisonOperator.MATCHES_REGEX -> actual.matches(expected);
            default -> false;
        };
    }

    private static boolean compareNumeric(double actual, String expectedStr, ComparisonOperator operator) {
        try {
            double expected = Double.parseDouble(expectedStr);
            return switch (operator) {
                case ComparisonOperator.EQUALS -> {
                    if (Math.abs(actual - expected) < 0.001) {
                        yield true;
                    }
                    yield false;
                }
                case ComparisonOperator.NOT_EQUALS -> {
                    if (Math.abs(actual - expected) >= 0.001) {
                        yield true;
                    }
                    yield false;
                }
                case ComparisonOperator.GREATER_THAN -> {
                    if (actual > expected) {
                        yield true;
                    }
                    yield false;
                }
                case ComparisonOperator.LESS_THAN -> {
                    if (actual < expected) {
                        yield true;
                    }
                    yield false;
                }
                case ComparisonOperator.GREATER_OR_EQUAL -> {
                    if (actual >= expected) {
                        yield true;
                    }
                    yield false;
                }
                case ComparisonOperator.LESS_OR_EQUAL -> {
                    if (actual <= expected) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

