/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.history;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.texboobcat.beautiful_statistics_screen.api.StatEntry;
import org.texboobcat.beautiful_statistics_screen.config.ModConfig;
import org.texboobcat.beautiful_statistics_screen.core.StatDataManager;
import org.texboobcat.beautiful_statistics_screen.util.CompressionUtil;

public class HistoryManager {
    private static final Gson GSON = new GsonBuilder().create();
    private static Path historyDirectory;
    private static final Map<class_2960, List<DataPoint>> historyCache;
    private static final int MAX_DATA_POINTS = 1000;
    private static final int CACHE_SIZE_LIMIT = 500;
    private static long lastLogTime;

    public static void initialize(Path gameDirectory) {
        historyDirectory = gameDirectory.resolve("beautiful_statistics_screen").resolve("history");
        try {
            Files.createDirectories(historyDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        HistoryManager.loadHistoryFromDisk();
    }

    public static void logCurrentStats() {
        long currentTime;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        lastLogTime = currentTime = System.currentTimeMillis();
        List stats = StatDataManager.getAllStats().stream().filter(e -> !e.isZero()).collect(Collectors.toList());
        for (StatEntry entry : stats) {
            class_2960 statId = entry.getStatId();
            List points = historyCache.computeIfAbsent(statId, k -> new ArrayList());
            points.add(new DataPoint(currentTime, entry.getValue()));
            if (points.size() <= 1000) continue;
            int toRemove = 200;
            points.subList(0, toRemove).clear();
        }
        if (historyCache.size() > 500) {
            HistoryManager.pruneCache();
        }
        HistoryManager.saveHistoryToDiskAsync();
    }

    public static List<DataPoint> getHistory(class_2960 statId) {
        List<DataPoint> points = historyCache.get(statId);
        if (points == null && (points = HistoryManager.loadHistoryForStat(statId)) != null && !points.isEmpty()) {
            historyCache.put(statId, points);
        }
        return points != null ? new ArrayList<DataPoint>(points) : new ArrayList();
    }

    public static Map<class_2960, List<DataPoint>> getHistoryBatch(List<class_2960> statIds) {
        HashMap<class_2960, List<DataPoint>> result = new HashMap<class_2960, List<DataPoint>>();
        for (class_2960 statId : statIds) {
            result.put(statId, HistoryManager.getHistory(statId));
        }
        return result;
    }

    public static void clearHistory(class_2960 statId) {
        historyCache.remove(statId);
        try {
            Files.deleteIfExists(HistoryManager.getHistoryFile(statId, true));
            Files.deleteIfExists(HistoryManager.getHistoryFile(statId, false));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void clearAllHistory() {
        historyCache.clear();
        try {
            Files.walk(historyDirectory, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(".json") || p.toString().endsWith(".json.gz")).forEach(p -> {
                try {
                    Files.delete(p);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<class_2960> getStatsWithHistory() {
        return new ArrayList<class_2960>(historyCache.keySet());
    }

    public static long getLastLogTime() {
        return lastLogTime;
    }

    public static CompressionStats getCompressionStats() {
        if (!Files.exists(historyDirectory, new LinkOption[0])) {
            return new CompressionStats(0L, 0L, 0L);
        }
        long totalSize = 0L;
        long compressedCount = 0L;
        long uncompressedCount = 0L;
        try {
            List files = Files.walk(historyDirectory, 1, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(".json") || p.toString().endsWith(".json.gz")).collect(Collectors.toList());
            for (Path file : files) {
                totalSize += Files.size(file);
                if (file.toString().endsWith(".gz")) {
                    ++compressedCount;
                    continue;
                }
                ++uncompressedCount;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new CompressionStats(totalSize, compressedCount, uncompressedCount);
    }

    private static void loadHistoryFromDisk() {
        if (!Files.exists(historyDirectory, new LinkOption[0])) {
            return;
        }
        try {
            Files.walk(historyDirectory, 1, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(".json") || p.toString().endsWith(".json.gz")).forEach(path -> {
                try {
                    String filename = path.getFileName().toString();
                    String encoded = filename.replace(".json.gz", "").replace(".json", "");
                    int firstSeparator = encoded.indexOf("__");
                    if (firstSeparator == -1) {
                        return;
                    }
                    String namespace = encoded.substring(0, firstSeparator);
                    String pathPart = encoded.substring(firstSeparator + 2).replace("__", "/");
                    class_2960 statId = new class_2960(namespace, pathPart);
                    List<DataPoint> points = HistoryManager.loadHistoryForStatFromPath(path);
                    if (points != null && !points.isEmpty()) {
                        historyCache.put(statId, points);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static List<DataPoint> loadHistoryForStat(class_2960 statId) {
        Path compressedFile = HistoryManager.getHistoryFile(statId, true);
        if (Files.exists(compressedFile, new LinkOption[0])) {
            return HistoryManager.loadHistoryForStatFromPath(compressedFile);
        }
        Path uncompressedFile = HistoryManager.getHistoryFile(statId, false);
        if (Files.exists(uncompressedFile, new LinkOption[0])) {
            return HistoryManager.loadHistoryForStatFromPath(uncompressedFile);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private static List<DataPoint> loadHistoryForStatFromPath(Path file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void saveHistoryToDiskAsync() {
        new Thread(() -> HistoryManager.saveHistoryToDisk(), "HistorySaver").start();
    }

    private static void saveHistoryToDisk() {
        boolean useCompression = ModConfig.getClient().compressHistoryFiles;
        for (Map.Entry<class_2960, List<DataPoint>> entry : historyCache.entrySet()) {
            Path file = HistoryManager.getHistoryFile(entry.getKey(), useCompression);
            try {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                if (useCompression) {
                    OutputStream fileOut = Files.newOutputStream(file, new OpenOption[0]);
                    try {
                        GZIPOutputStream gzipOut = new GZIPOutputStream(fileOut);
                        try {
                            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)gzipOut, "UTF-8");
                            try {
                                GSON.toJson(entry.getValue(), (Appendable)writer);
                                continue;
                            }
                            finally {
                                ((Writer)writer).close();
                                continue;
                            }
                        }
                        finally {
                            gzipOut.close();
                            continue;
                        }
                    }
                    finally {
                        if (fileOut != null) {
                            fileOut.close();
                        }
                        continue;
                    }
                }
                BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);
                try {
                    GSON.toJson(entry.getValue(), (Appendable)writer);
                }
                finally {
                    if (writer == null) continue;
                    ((Writer)writer).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static Path getHistoryFile(class_2960 statId, boolean compressed) {
        Object filename = statId.toString().replace(":", "__").replace("/", "__");
        filename = (String)filename + (compressed ? ".json.gz" : ".json");
        return historyDirectory.resolve((String)filename);
    }

    private static void pruneCache() {
        ArrayList<Map.Entry<class_2960, List<DataPoint>>> entries = new ArrayList<Map.Entry<class_2960, List<DataPoint>>>(historyCache.entrySet());
        entries.sort((a, b) -> {
            long timeA = ((List)a.getValue()).isEmpty() ? 0L : ((DataPoint)((List)a.getValue()).get((int)(((List)a.getValue()).size() - 1))).timestamp;
            long timeB = ((List)b.getValue()).isEmpty() ? 0L : ((DataPoint)((List)b.getValue()).get((int)(((List)b.getValue()).size() - 1))).timestamp;
            return Long.compare(timeA, timeB);
        });
        int toRemove = 100;
        for (int i = 0; i < toRemove && i < entries.size(); ++i) {
            historyCache.remove(((Map.Entry)entries.get(i)).getKey());
        }
    }

    static {
        historyCache = new ConcurrentHashMap<class_2960, List<DataPoint>>();
        lastLogTime = 0L;
    }

    public static class DataPoint {
        public final long timestamp;
        public final long value;

        public DataPoint(long timestamp, long value) {
            this.timestamp = timestamp;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataPoint dataPoint = (DataPoint)o;
            return this.timestamp == dataPoint.timestamp && this.value == dataPoint.value;
        }

        public int hashCode() {
            return Objects.hash(this.timestamp, this.value);
        }
    }

    public static class CompressionStats {
        public final long totalSize;
        public final long compressedFileCount;
        public final long uncompressedFileCount;

        public CompressionStats(long totalSize, long compressedFileCount, long uncompressedFileCount) {
            this.totalSize = totalSize;
            this.compressedFileCount = compressedFileCount;
            this.uncompressedFileCount = uncompressedFileCount;
        }

        public String getFormattedSize() {
            return CompressionUtil.formatBytes(this.totalSize);
        }

        public long getTotalFileCount() {
            return this.compressedFileCount + this.uncompressedFileCount;
        }
    }
}

