/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.beautiful_statistics_screen.network;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3442;
import net.minecraft.class_3445;
import net.minecraft.class_3448;
import net.minecraft.class_3468;
import net.minecraft.class_437;
import net.minecraft.class_7923;
import org.texboobcat.beautiful_statistics_screen.Beautiful_statistics_screen;
import org.texboobcat.beautiful_statistics_screen.client.gui.SharedStatsScreen;
import org.texboobcat.beautiful_statistics_screen.config.ModConfig;
import org.texboobcat.beautiful_statistics_screen.network.SharedStatsCache;

public class NetworkHandler {
    public static final class_2960 REQUEST_STATS = new class_2960("beautiful_statistics_screen", "request_stats");
    public static final class_2960 STATS_DATA = new class_2960("beautiful_statistics_screen", "stats_data");
    public static final class_2960 STAT_UPDATE = new class_2960("beautiful_statistics_screen", "stat_update");
    public static final class_2960 SYNC_PINNED = new class_2960("beautiful_statistics_screen", "sync_pinned");

    public static void register() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)REQUEST_STATS, RequestStatsPacket::handle);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (class_2960)STATS_DATA, StatsDataPacket::handle);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (class_2960)STAT_UPDATE, StatUpdatePacket::handle);
    }

    public static class StatUpdatePacket {
        private final String statId;
        private final long value;

        public StatUpdatePacket(String statId, long value) {
            this.statId = statId;
            this.value = value;
        }

        public void encode(class_2540 buf) {
            buf.method_10814(this.statId);
            buf.writeLong(this.value);
        }

        public static StatUpdatePacket decode(class_2540 buf) {
            return new StatUpdatePacket(buf.method_19772(), buf.readLong());
        }

        public static void handle(class_2540 buf, NetworkManager.PacketContext context) {
            StatUpdatePacket packet = StatUpdatePacket.decode(buf);
            context.queue(() -> {});
        }

        public static void sendToPlayer(class_3222 player, String statId, long value) {
            StatUpdatePacket packet = new StatUpdatePacket(statId, value);
            class_2540 buf = new class_2540(Unpooled.buffer());
            packet.encode(buf);
            NetworkManager.sendToPlayer((class_3222)player, (class_2960)STAT_UPDATE, (class_2540)buf);
        }
    }

    public static class StatsDataPacket {
        private final String playerName;
        private final Map<String, Long> stats;

        public StatsDataPacket(String playerName, Map<String, Long> stats) {
            this.playerName = playerName;
            this.stats = stats;
        }

        public void encode(class_2540 buf) {
            buf.method_10814(this.playerName);
            buf.writeInt(this.stats.size());
            for (Map.Entry<String, Long> entry : this.stats.entrySet()) {
                buf.method_10814(entry.getKey());
                buf.writeLong(entry.getValue().longValue());
            }
        }

        public static StatsDataPacket decode(class_2540 buf) {
            String playerName = buf.method_19772();
            int size = buf.readInt();
            HashMap<String, Long> stats = new HashMap<String, Long>();
            for (int i = 0; i < size; ++i) {
                stats.put(buf.method_19772(), buf.readLong());
            }
            return new StatsDataPacket(playerName, stats);
        }

        public static void handle(class_2540 buf, NetworkManager.PacketContext context) {
            StatsDataPacket packet = StatsDataPacket.decode(buf);
            context.queue(() -> {
                class_310 mc = class_310.method_1551();
                if (mc.field_1724 != null) {
                    SharedStatsCache.setSharedStats(packet.playerName, packet.stats);
                    mc.field_1724.method_43496((class_2561)class_2561.method_43470((String)("\u00a7aReceived stats for " + packet.playerName)));
                    if (mc.field_1755 == null) {
                        mc.method_1507((class_437)new SharedStatsScreen(null, packet.playerName, packet.stats));
                    }
                }
            });
        }

        public static void sendToPlayer(class_3222 requestingPlayer, String targetPlayerName) {
            if (!ModConfig.getServer().allowStatSharing) {
                requestingPlayer.method_43496((class_2561)class_2561.method_43470((String)"\u00a7cStat sharing is disabled on this server"));
                return;
            }
            class_3222 targetPlayer = requestingPlayer.method_5682().method_3760().method_14566(targetPlayerName);
            if (targetPlayer == null) {
                requestingPlayer.method_43496((class_2561)class_2561.method_43470((String)("\u00a7cPlayer not found: " + targetPlayerName)));
                return;
            }
            HashMap<String, Long> stats = new HashMap<String, Long>();
            class_3442 statsCounter = targetPlayer.method_14248();
            for (class_2960 statId : class_7923.field_41183) {
                class_3445 stat = class_3468.field_15419.method_14956((Object)statId);
                int value = statsCounter.method_15025(stat);
                if (value <= 0) continue;
                stats.put("minecraft:custom/" + statId.method_12832(), Long.valueOf(value));
            }
            StatsDataPacket.addItemStats(stats, statsCounter, (class_3448<class_1792>)class_3468.field_15372, "used");
            StatsDataPacket.addItemStats(stats, statsCounter, (class_3448<class_1792>)class_3468.field_15370, "crafted");
            StatsDataPacket.addItemStats(stats, statsCounter, (class_3448<class_1792>)class_3468.field_15383, "broken");
            StatsDataPacket.addEntityStats(stats, statsCounter, class_3468.field_15403, "killed");
            StatsDataPacket.addEntityStats(stats, statsCounter, class_3468.field_15411, "killed_by");
            StatsDataPacket.addBlockStats(stats, statsCounter, (class_3448<class_2248>)class_3468.field_15427, "mined");
            StatsDataPacket packet = new StatsDataPacket(targetPlayerName, stats);
            class_2540 buf = new class_2540(Unpooled.buffer());
            packet.encode(buf);
            NetworkManager.sendToPlayer((class_3222)requestingPlayer, (class_2960)STATS_DATA, (class_2540)buf);
            if (ModConfig.getServer().logStatChanges) {
                Beautiful_statistics_screen.LOGGER.info("Player {} requested stats for {}", (Object)requestingPlayer.method_5477().getString(), (Object)targetPlayerName);
            }
        }

        private static void addItemStats(Map<String, Long> stats, class_3442 counter, class_3448<class_1792> statType, String prefix) {
            for (class_1792 item : class_7923.field_41178) {
                class_3445 stat = statType.method_14956((Object)item);
                int value = counter.method_15025(stat);
                if (value <= 0) continue;
                class_2960 itemId = class_7923.field_41178.method_10221((Object)item);
                stats.put(itemId.method_12836() + ":" + prefix + "/" + itemId.method_12832(), Long.valueOf(value));
            }
        }

        private static void addEntityStats(Map<String, Long> stats, class_3442 counter, class_3448<class_1299<?>> statType, String prefix) {
            for (class_1299 entityType : class_7923.field_41177) {
                class_3445 stat = statType.method_14956((Object)entityType);
                int value = counter.method_15025(stat);
                if (value <= 0) continue;
                class_2960 entityId = class_7923.field_41177.method_10221((Object)entityType);
                stats.put(entityId.method_12836() + ":" + prefix + "/" + entityId.method_12832(), Long.valueOf(value));
            }
        }

        private static void addBlockStats(Map<String, Long> stats, class_3442 counter, class_3448<class_2248> statType, String prefix) {
            for (class_2248 block : class_7923.field_41175) {
                class_3445 stat = statType.method_14956((Object)block);
                int value = counter.method_15025(stat);
                if (value <= 0) continue;
                class_2960 blockId = class_7923.field_41175.method_10221((Object)block);
                stats.put(blockId.method_12836() + ":" + prefix + "/" + blockId.method_12832(), Long.valueOf(value));
            }
        }
    }

    public static class RequestStatsPacket {
        private final String targetPlayer;

        public RequestStatsPacket(String targetPlayer) {
            this.targetPlayer = targetPlayer;
        }

        public void encode(class_2540 buf) {
            buf.method_10814(this.targetPlayer);
        }

        public static RequestStatsPacket decode(class_2540 buf) {
            return new RequestStatsPacket(buf.method_19772());
        }

        public static void handle(class_2540 buf, NetworkManager.PacketContext context) {
            RequestStatsPacket packet = RequestStatsPacket.decode(buf);
            context.queue(() -> {
                class_1657 patt0$temp = context.getPlayer();
                if (patt0$temp instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)patt0$temp;
                    StatsDataPacket.sendToPlayer(serverPlayer, packet.targetPlayer);
                }
            });
        }

        public void send() {
            class_2540 buf = new class_2540(Unpooled.buffer());
            this.encode(buf);
            NetworkManager.sendToServer((class_2960)REQUEST_STATS, (class_2540)buf);
        }
    }
}

