/*
 * Decompiled with CFR 0.152.
 */
package net.duckyruby.combatlog;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CombatLog
extends JavaPlugin
implements Listener,
TabExecutor {
    private final Map<UUID, Integer> combatTagged = new HashMap<UUID, Integer>();
    private int combatTime = 10;

    public void onEnable() {
        this.saveDefaultConfig();
        this.combatTime = this.getConfig().getInt("combat-time", 10);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("combatlog").setExecutor((CommandExecutor)this);
        new BukkitRunnable(){

            public void run() {
                Iterator<Map.Entry<UUID, Integer>> it = CombatLog.this.combatTagged.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<UUID, Integer> entry = it.next();
                    UUID uuid = entry.getKey();
                    int time = entry.getValue();
                    Player player = Bukkit.getPlayer((UUID)uuid);
                    if (player != null && player.isOnline()) {
                        if (time <= 0) {
                            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(String.valueOf(ChatColor.GREEN) + "Du bist nicht mehr im Kampf!"));
                            it.remove();
                            continue;
                        }
                        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(String.valueOf(ChatColor.RED) + "\u2694 Im Kampf: " + time + "s"));
                        entry.setValue(time - 1);
                        continue;
                    }
                    it.remove();
                }
            }
        }.runTaskTimer((Plugin)this, 20L, 20L);
    }

    public void onDisable() {
        this.combatTagged.clear();
    }

    @EventHandler
    public void onHit(EntityDamageByEntityEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof Player) {
            Player victim = (Player)entity;
            entity = e.getDamager();
            if (entity instanceof Player) {
                Player attacker = (Player)entity;
                this.setCombat(attacker);
                this.setCombat(victim);
            }
        }
    }

    @EventHandler
    public void onCommand(PlayerCommandPreprocessEvent e) {
        Player p = e.getPlayer();
        if (this.isInCombat(p) && !p.isOp()) {
            p.sendMessage(String.valueOf(ChatColor.RED) + "Du kannst im Kampf keine Befehle nutzen!");
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        Player p = e.getPlayer();
        if (this.isInCombat(p)) {
            p.setHealth(0.0);
            this.combatTagged.remove(p.getUniqueId());
        }
    }

    private void setCombat(Player p) {
        this.combatTagged.put(p.getUniqueId(), this.combatTime);
    }

    private boolean isInCombat(Player p) {
        return this.combatTagged.containsKey(p.getUniqueId());
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
            if (sender.isOp()) {
                this.reloadConfig();
                this.combatTime = this.getConfig().getInt("combat-time", 10);
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "CombatLog Config neu geladen!");
            } else {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Keine Rechte!");
            }
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Benutzung: /combatlog reload");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        if (args.length == 1) {
            return Arrays.asList("reload");
        }
        return Collections.emptyList();
    }
}

