/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bootstrap.bukkit.util;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.bukkit.Bukkit;

public final class BootstrapUtil {
    public static File getPluginDirectory() throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Class<?> optionSet;
        Class<?> minecraftServer;
        try {
            minecraftServer = Class.forName("net.minecraft.server.MinecraftServer");
        }
        catch (ClassNotFoundException ex) {
            String v = Bukkit.getServer().getClass().getPackage().getName();
            v = v.substring(v.lastIndexOf(46) + 1);
            try {
                minecraftServer = Class.forName("net.minecraft.server." + v + ".MinecraftServer");
            }
            catch (ClassNotFoundException ex2) {
                throw new IllegalStateException("Couldn't find MinecraftServer class!");
            }
        }
        try {
            optionSet = Class.forName("org.bukkit.craftbukkit.libs.joptsimple.OptionSet");
        }
        catch (ClassNotFoundException ex) {
            try {
                optionSet = Class.forName("joptsimple.OptionSet");
            }
            catch (ClassNotFoundException ex2) {
                throw new IllegalStateException("Couldn't find OptionSet class!");
            }
        }
        Method valueOf = optionSet.getMethod("valueOf", String.class);
        Field optionSetField = null;
        Field serverField = null;
        for (Field field : minecraftServer.getDeclaredFields()) {
            if (field.getType() == optionSet) {
                optionSetField = field;
                continue;
            }
            if (field.getType() != minecraftServer || !Modifier.isStatic(field.getModifiers())) continue;
            serverField = field;
        }
        if (optionSetField == null) {
            throw new IllegalStateException("Couldn't found OptionSet field!");
        }
        if (serverField == null) {
            throw new IllegalStateException("Couldn't found MinecraftServer field!");
        }
        optionSetField.setAccessible(true);
        serverField.setAccessible(true);
        Object server = serverField.get(null);
        Object optionSetObj = optionSetField.get(server);
        return (File)valueOf.invoke(optionSetObj, "plugins");
    }

    private BootstrapUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

