/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bootstrap.instance;

import info.cho.passwords.fairy.bootstrap.instance.PluginInstance;
import info.cho.passwords.fairy.libs.gson.JsonObject;
import info.cho.passwords.fairy.log.Log;
import info.cho.passwords.fairy.plugin.Plugin;
import info.cho.passwords.fairy.plugin.PluginAction;
import info.cho.passwords.fairy.plugin.PluginDescription;
import info.cho.passwords.fairy.plugin.PluginManager;
import info.cho.passwords.fairy.plugin.initializer.PluginClassInitializer;
import java.util.concurrent.CompletableFuture;

public abstract class AbstractPluginInstance
implements PluginInstance {
    private final PluginClassInitializer pluginClassInitializer;
    protected final CompletableFuture<Plugin> pluginCompletableFuture = new CompletableFuture();
    protected Plugin plugin;
    protected ClassLoader classLoader;

    protected abstract ClassLoader getClassLoader();

    protected abstract PluginAction getPluginAction();

    @Override
    public void init(JsonObject jsonObject) {
        PluginDescription pluginDescription = new PluginDescription(jsonObject);
        this.classLoader = this.pluginClassInitializer.initializeClassLoader(pluginDescription.getName(), this.getClassLoader());
        this.plugin = this.pluginClassInitializer.create(pluginDescription.getMainClass(), this.classLoader);
        PluginManager.INSTANCE.onPluginPreLoaded(this.classLoader, pluginDescription, this.getPluginAction(), this.pluginCompletableFuture);
        this.plugin.initializePlugin(pluginDescription, this.getPluginAction(), this.classLoader);
    }

    @Override
    public void onLoad() {
        PluginManager.INSTANCE.addPlugin(this.plugin);
        PluginManager.INSTANCE.onPluginInitial(this.plugin);
        this.pluginClassInitializer.onPluginLoad(this.plugin);
        this.plugin.onInitial();
    }

    @Override
    public void onEnable() {
        block3: {
            this.plugin.onPreEnable();
            if (this.plugin.isClosed()) {
                return;
            }
            PluginManager.INSTANCE.onPluginEnable(this.plugin);
            try {
                this.plugin.onPluginEnable();
            }
            catch (Throwable throwable) {
                if (this.plugin.isClosed()) break block3;
                Log.error(throwable);
            }
        }
    }

    @Override
    public void onDisable() {
        try {
            this.plugin.onPluginDisable();
        }
        catch (Throwable throwable) {
            Log.error(throwable);
        }
        this.plugin.getCompositeTerminable().closeAndReportException();
        PluginManager.INSTANCE.onPluginDisable(this.plugin);
        PluginManager.INSTANCE.removePlugin(this.plugin);
        this.pluginClassInitializer.onPluginUnload(this.plugin);
    }

    public AbstractPluginInstance(PluginClassInitializer pluginClassInitializer) {
        this.pluginClassInitializer = pluginClassInitializer;
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }
}

