/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.command;

import info.cho.passwords.fairy.bukkit.command.event.BukkitCommandContext;
import info.cho.passwords.fairy.bukkit.util.JavaPluginUtil;
import info.cho.passwords.fairy.command.BaseCommand;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class BukkitCommandExecutor
extends Command {
    private final BaseCommand command;
    private final String fallbackPrefix;

    public BukkitCommandExecutor(BaseCommand command, String[] name) {
        super(name[0]);
        JavaPlugin javaPlugin;
        this.command = command;
        if (name.length > 1) {
            this.setAliases(Arrays.asList(Arrays.copyOfRange(name, 1, name.length)));
        }
        this.fallbackPrefix = (javaPlugin = JavaPluginUtil.getProvidingPlugin(command.getClass())) != null ? javaPlugin.getName() : "Fairy";
    }

    @NotNull
    public String getDescription() {
        return this.command.getDescription();
    }

    public boolean execute(@NotNull CommandSender commandSender, @NotNull String mainCommand, String[] args) {
        BukkitCommandContext commandContext = new BukkitCommandContext(commandSender, args);
        try {
            this.command.execute(commandContext);
        }
        catch (Throwable throwable) {
            this.command.onError(commandContext, throwable);
        }
        return true;
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, String[] args) throws IllegalArgumentException {
        BukkitCommandContext commandContext = new BukkitCommandContext(sender, args);
        try {
            return this.command.completeCommand(commandContext);
        }
        catch (Throwable throwable) {
            this.command.onError(commandContext, throwable);
            return Collections.emptyList();
        }
    }

    public BaseCommand getCommand() {
        return this.command;
    }

    public String getFallbackPrefix() {
        return this.fallbackPrefix;
    }
}

