/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.events;

import info.cho.passwords.fairy.bukkit.FairyBukkitPlatform;
import info.cho.passwords.fairy.bukkit.util.BukkitPos;
import info.cho.passwords.fairy.container.InjectableComponent;
import info.cho.passwords.fairy.container.PreInitialize;
import info.cho.passwords.fairy.event.GlobalEventNode;
import info.cho.passwords.fairy.mc.MCPlayer;
import info.cho.passwords.fairy.mc.MCWorld;
import info.cho.passwords.fairy.mc.event.AsyncLoginEvent;
import info.cho.passwords.fairy.mc.event.MCPlayerChangedWorldEvent;
import info.cho.passwords.fairy.mc.event.MCPlayerJoinEvent;
import info.cho.passwords.fairy.mc.event.MCPlayerMoveEvent;
import info.cho.passwords.fairy.mc.event.MCPlayerQuitEvent;
import info.cho.passwords.fairy.mc.event.MCPlayerTeleportEvent;
import info.cho.passwords.fairy.mc.event.NativePlayerLoginEvent;
import info.cho.passwords.fairy.mc.event.world.MCWorldUnloadEvent;
import info.cho.passwords.fairy.mc.registry.player.MCPlayerRegistry;
import info.cho.passwords.fairy.mc.util.Position;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

@InjectableComponent
public class BukkitEventTransformer {
    public static final EventPriority PRIORITY_REGISTRATION = EventPriority.MONITOR;
    private static final Listener DUMMY_LISTENER = new Listener(){};
    private final MCPlayerRegistry playerRegistry;
    private Map<Class<? extends Event>, Class<?>> bukkitToMC;

    @PreInitialize
    public void onPreInitialize() {
        this.bukkitToMC = new ConcurrentHashMap();
        this.register(AsyncPlayerPreLoginEvent.class, AsyncLoginEvent.class, this::transformAsyncLoginEvent);
        this.register(PlayerJoinEvent.class, NativePlayerLoginEvent.class, EventPriority.LOWEST, this::transformNativeLoginEvent);
        this.register(PlayerJoinEvent.class, MCPlayerJoinEvent.class, event -> new MCPlayerJoinEvent(this.playerRegistry.getByPlatform(event.getPlayer())));
        this.register(PlayerQuitEvent.class, MCPlayerQuitEvent.class, event -> {
            MCPlayer player = this.playerRegistry.findByPlatform(event.getPlayer());
            if (player == null) {
                return null;
            }
            return new MCPlayerQuitEvent(player);
        });
        this.register(PlayerMoveEvent.class, MCPlayerMoveEvent.class, (B event) -> {
            Player player = event.getPlayer();
            Position fromPos = BukkitPos.toMCPos(event.getFrom());
            Position toPos = BukkitPos.toMCPos(event.getTo());
            MCPlayer mcPlayer = this.playerRegistry.findByPlatform(player);
            if (mcPlayer == null) {
                return null;
            }
            return new MCPlayerMoveEvent(mcPlayer, fromPos, toPos);
        }, (B event, M mcEvent) -> {
            if (mcEvent.isCancelled()) {
                event.setCancelled(true);
                return;
            }
            if (mcEvent.isChanged()) {
                event.setTo(BukkitPos.toBukkitLocation(mcEvent.getToPos()));
            }
        });
        this.register(PlayerTeleportEvent.class, MCPlayerTeleportEvent.class, (B event) -> {
            Position fromPos = BukkitPos.toMCPos(event.getFrom());
            Position toPos = BukkitPos.toMCPos(event.getTo());
            MCPlayer mcPlayer = this.playerRegistry.findByPlatform(event.getPlayer());
            if (mcPlayer == null) {
                return null;
            }
            return new MCPlayerTeleportEvent(mcPlayer, fromPos, toPos);
        }, (B event, M mcEvent) -> {
            if (mcEvent.isCancelled()) {
                event.setCancelled(true);
                return;
            }
            if (mcEvent.isChanged()) {
                event.setTo(BukkitPos.toBukkitLocation(mcEvent.getToPos()));
            }
        });
        this.register(WorldUnloadEvent.class, MCWorldUnloadEvent.class, (B event) -> new MCWorldUnloadEvent(MCWorld.from(event.getWorld())), (B event, M mcEvent) -> {
            if (mcEvent.isCancelled()) {
                event.setCancelled(true);
            }
        });
        this.register(PlayerChangedWorldEvent.class, MCPlayerChangedWorldEvent.class, event -> {
            MCPlayer mcPlayer = this.playerRegistry.findByPlatform(event.getPlayer());
            if (mcPlayer == null) {
                return null;
            }
            return new MCPlayerChangedWorldEvent(mcPlayer, MCWorld.from(event.getFrom()), MCWorld.from(event.getPlayer().getWorld()));
        });
    }

    private NativePlayerLoginEvent transformNativeLoginEvent(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        return new NativePlayerLoginEvent(player, player.getUniqueId(), player.getName(), player.getAddress().getAddress());
    }

    private AsyncLoginEvent transformAsyncLoginEvent(AsyncPlayerPreLoginEvent event) {
        AsyncLoginEvent asyncLoginEvent = new AsyncLoginEvent(event.getName(), event.getUniqueId(), event.getAddress());
        asyncLoginEvent.setCancelled(event.getLoginResult() != AsyncPlayerPreLoginEvent.Result.ALLOWED);
        return asyncLoginEvent;
    }

    @Nullable
    public Class<?> getMC(Class<? extends Event> bukkitEvent) {
        return this.bukkitToMC.get(bukkitEvent);
    }

    private <B extends Event, M extends info.cho.passwords.fairy.event.Event> void register(Class<B> bukkitClass, Class<M> mcClass, Function<B, M> transformer) {
        this.register(bukkitClass, mcClass, transformer, null);
    }

    private <B extends Event, M extends info.cho.passwords.fairy.event.Event> void register(Class<B> bukkitClass, Class<M> mcClass, EventPriority priority, Function<B, M> transformer) {
        this.register(bukkitClass, mcClass, priority, transformer, null);
    }

    private <B extends Event, M extends info.cho.passwords.fairy.event.Event> void register(Class<B> bukkitClass, Class<M> mcClass, Function<B, M> transformer, BiConsumer<B, M> postProcessing) {
        this.register(bukkitClass, mcClass, PRIORITY_REGISTRATION, transformer, postProcessing);
    }

    private <B extends Event, M extends info.cho.passwords.fairy.event.Event> void register(Class<B> bukkitClass, Class<M> mcClass, EventPriority priority, Function<B, M> transformer, BiConsumer<B, M> postProcessing) {
        this.bukkitToMC.put(bukkitClass, mcClass);
        Bukkit.getPluginManager().registerEvent(bukkitClass, DUMMY_LISTENER, priority, (listener, event) -> {
            if (!bukkitClass.isInstance(event)) {
                return;
            }
            info.cho.passwords.fairy.event.Event mcEvent = (info.cho.passwords.fairy.event.Event)transformer.apply((Event)bukkitClass.cast(event));
            if (mcEvent == null) {
                return;
            }
            GlobalEventNode.get().call(mcEvent);
            if (postProcessing != null) {
                postProcessing.accept((Event)bukkitClass.cast(event), mcEvent);
            }
        }, (Plugin)FairyBukkitPlatform.PLUGIN);
    }

    public BukkitEventTransformer(MCPlayerRegistry playerRegistry) {
        this.playerRegistry = playerRegistry;
    }
}

