/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.events;

import info.cho.passwords.fairy.bukkit.FairyBukkitPlatform;
import info.cho.passwords.fairy.bukkit.listener.RegisterAsListener;
import info.cho.passwords.fairy.container.InjectableComponent;
import info.cho.passwords.fairy.container.PostInitialize;
import info.cho.passwords.fairy.util.Stacktrace;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.bukkit.Server;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;

@InjectableComponent
@RegisterAsListener
public class GlobalEventListener
implements Listener {
    private final Set<HandlerList> handlerLists = Collections.newSetFromMap(new IdentityHashMap());
    private final List<Consumer<Event>> listeners = new ArrayList<Consumer<Event>>();
    private final Server server;

    @PostInitialize
    public void onPostInitialize() {
        this.register(Collections.emptyList());
    }

    @EventHandler
    public void onPluginEnable(PluginEnableEvent event) {
        Plugin plugin = event.getPlugin();
        if (!plugin.isEnabled()) {
            return;
        }
        URL url = this.getClassLoaderURLFromClass(plugin.getClass());
        URL bukkitUrl = this.getClassLoaderURLFromClass(Server.class);
        if (url == null || bukkitUrl == null) {
            return;
        }
        this.register(Arrays.asList(url, bukkitUrl));
    }

    private URL getClassLoaderURLFromClass(Class<?> clazz) {
        return clazz.getProtectionDomain().getCodeSource().getLocation();
    }

    public void addListener(Consumer<Event> listener) {
        this.listeners.add(listener);
    }

    private void onEventFired(Event event) {
        for (Consumer<Event> listener : this.listeners) {
            listener.accept(event);
        }
    }

    private void register(List<URL> urls) {
        JavaPlugin mainPlugin = FairyBukkitPlatform.PLUGIN;
        Listener listener = new Listener(){};
        try {
            for (ClassInfo classInfo : this.scan(urls)) {
                this.registerClass((Plugin)mainPlugin, listener, classInfo);
            }
        }
        catch (Throwable throwable) {
            Stacktrace.print(throwable);
        }
    }

    private void registerClass(Plugin mainPlugin, Listener listener, ClassInfo classInfo) {
        Class<?> eventClass;
        try {
            eventClass = Class.forName(classInfo.getName());
        }
        catch (ClassNotFoundException ex) {
            return;
        }
        HandlerList handlerList = this.getHandlerList(eventClass);
        if (handlerList == null) {
            return;
        }
        EventExecutor eventExecutor = (ignored, event) -> this.onEventFired(event);
        handlerList.register(new RegisteredListener(listener, eventExecutor, EventPriority.NORMAL, mainPlugin, false));
    }

    private boolean shouldRegisterEventClass(Class<?> eventClass) {
        return !eventClass.getName().equals("com.destroystokyo.paper.event.player.PlayerHandshakeEvent");
    }

    @Nullable
    private HandlerList getHandlerList(Class<?> clazz) {
        try {
            Method method = clazz.getDeclaredMethod("getHandlerList", new Class[0]);
            method.setAccessible(true);
            HandlerList handlerList = (HandlerList)method.invoke(null, new Object[0]);
            if (!this.shouldRegisterEventClass(clazz)) {
                return null;
            }
            if (this.handlerLists.add(handlerList)) {
                return handlerList;
            }
            return null;
        }
        catch (NoSuchMethodException e) {
            if (clazz.getSuperclass() != null && !clazz.getSuperclass().equals(Event.class) && Event.class.isAssignableFrom(clazz.getSuperclass())) {
                return this.getHandlerList(clazz.getSuperclass().asSubclass(Event.class));
            }
            return null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    private ClassInfoList scan(List<URL> urls) {
        ClassGraph classGraph = new ClassGraph();
        if (!urls.isEmpty()) {
            classGraph.overrideClasspath(urls.toArray(new URL[0]));
        }
        return classGraph.enableClassInfo().scan().getClassInfo(Event.class.getName()).getSubclasses().filter(classInfo -> !classInfo.isAbstract());
    }

    public GlobalEventListener(Server server) {
        this.server = server;
    }
}

