/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.gui.pane;

import info.cho.passwords.fairy.bukkit.gui.pane.AbstractPane;
import info.cho.passwords.fairy.bukkit.gui.pane.mapping.PaneMapping;
import info.cho.passwords.fairy.bukkit.gui.slot.GuiSlot;
import java.util.ArrayList;
import java.util.List;

public class PaginatedPane
extends AbstractPane {
    private final List<GuiSlot> guiSlots = new ArrayList<GuiSlot>();
    private int page;

    public PaginatedPane(PaneMapping paneMapping) {
        super(paneMapping);
    }

    public void clear() {
        this.guiSlots.clear();
    }

    public void addSlot(GuiSlot guiSlot) {
        this.guiSlots.add(guiSlot);
    }

    @Override
    public GuiSlot getSlot(int slot) {
        int index = this.page * this.paneMapping.getSize() + this.slotToIndex(slot);
        if (index >= this.guiSlots.size()) {
            return null;
        }
        return this.guiSlots.get(index);
    }

    private int slotToIndex(int slot) {
        int index = this.paneMapping.getIndex(slot);
        if (index == -1) {
            throw new IllegalArgumentException("Slot " + slot + " is not in the slots array");
        }
        return index;
    }

    public int getPage() {
        return this.page;
    }

    public int getMaxPage() {
        return (int)Math.ceil((double)this.guiSlots.size() / (double)this.paneMapping.getSize());
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void nextPage() {
        this.setPage(this.page + 1);
    }

    public void previousPage() {
        this.setPage(this.page - 1);
    }
}

