/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.gui.pane.mapping;

import info.cho.passwords.fairy.bukkit.gui.pane.mapping.PaneMapping;
import java.util.ArrayList;
import java.util.BitSet;
import org.apache.commons.lang3.ArrayUtils;

public class OutlinePaneMapping
implements PaneMapping {
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private int[] cachedSlots;
    private BitSet slotSet;

    @Override
    public int getSize() {
        this.cache();
        return this.cachedSlots.length;
    }

    private void cache() {
        if (this.cachedSlots == null) {
            int i;
            ArrayList<Integer> slots = new ArrayList<Integer>();
            this.slotSet = new BitSet(this.width * this.height);
            for (i = 0; i < this.width; ++i) {
                slots.add(this.getMenuSlot(i, 0));
            }
            for (i = 1; i < this.height - 1; ++i) {
                slots.add(this.getMenuSlot(0, i));
                slots.add(this.getMenuSlot(this.width - 1, i));
            }
            for (i = 0; i < this.width; ++i) {
                slots.add(this.getMenuSlot(i, this.height - 1));
            }
            this.cachedSlots = new int[slots.size()];
            for (i = 0; i < slots.size(); ++i) {
                int slot;
                this.cachedSlots[i] = slot = ((Integer)slots.get(i)).intValue();
                this.slotSet.set(slot);
            }
        }
    }

    public int getMenuSlot(int index) {
        return this.x + index % this.width + (this.y + index / this.width) * 9;
    }

    public int getMenuSlot(int x, int y) {
        return this.getMenuSlot(x + y * this.width);
    }

    @Override
    public int[] getSlots() {
        this.cache();
        return this.cachedSlots;
    }

    @Override
    public int getSlot(int index) {
        this.cache();
        return this.cachedSlots[index];
    }

    @Override
    public int getIndex(int slot) {
        this.cache();
        return this.slotSet.get(slot) ? ArrayUtils.indexOf((int[])this.cachedSlots, (int)slot) : -1;
    }

    @Override
    public int getSlot(int x, int y) {
        int slot = this.getMenuSlot(x, y);
        this.cache();
        if (this.slotSet.get(slot)) {
            return slot;
        }
        throw new IllegalArgumentException("Slot " + x + ", " + y + " is not in the slots array");
    }

    @Override
    public boolean hasAxis() {
        return true;
    }

    public OutlinePaneMapping(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }
}

