/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.gui.slot;

import info.cho.passwords.fairy.bukkit.events.BukkitEventFilter;
import info.cho.passwords.fairy.bukkit.gui.Gui;
import info.cho.passwords.fairy.bukkit.gui.pane.Pane;
import info.cho.passwords.fairy.bukkit.gui.slot.GuiSlot;
import info.cho.passwords.fairy.event.EventNode;
import info.cho.passwords.fairy.libs.xseries.XMaterial;
import info.cho.passwords.fairy.mc.scheduler.MCSchedulers;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemSelectorGuiSlot
implements GuiSlot {
    private final int slot;
    private final ItemStack emptyItemStack;
    private final BiPredicate<InventoryClickEvent, ItemStack> canPickupPredicate;
    private final BiPredicate<InventoryClickEvent, ItemStack> canPlacePredicate;
    private final BiConsumer<InventoryClickEvent, ItemStack> pickupCallback;
    private final BiConsumer<InventoryClickEvent, ItemStack> placeCallback;
    private final BiConsumer<InventoryClickEvent, ItemStack> updateCallback;
    private ItemStack currentItemStack;

    public void update(@NotNull Player player, @NotNull Gui gui) {
        this.update(player, this.slot, gui);
    }

    public boolean isEmpty(Gui gui) {
        ItemStack itemStack = gui.getItem(this.slot);
        return !this.isItemNotEmpty(itemStack) || itemStack.isSimilar(this.emptyItemStack);
    }

    @Override
    public ItemStack getItemStack(@NotNull Player player, @NotNull Gui gui) {
        if (this.isItemNotEmpty(this.currentItemStack)) {
            return this.currentItemStack;
        }
        return this.emptyItemStack;
    }

    @Override
    public void onInventoryClick(@NotNull InventoryClickEvent event, @NotNull Gui gui) {
        Player player = (Player)event.getWhoClicked();
        if (this.isEmpty(gui)) {
            this.handleEmptyInventoryClick(player, gui, event);
        } else {
            this.handleNotEmptyInventoryClick(event, gui, player);
        }
    }

    private void handleNotEmptyInventoryClick(@NotNull InventoryClickEvent event, @NotNull Gui gui, Player player) {
        InventoryAction action = event.getAction();
        if (this.checkPrePickup(event, action)) {
            return;
        }
        if (this.checkPrePlace(event, action)) {
            return;
        }
        event.setCancelled(false);
        switch (event.getAction()) {
            case PICKUP_ONE: 
            case DROP_ONE_SLOT: {
                this.onPickup(event, this.getCopyOfItemWithAmount(event.getCurrentItem(), 1));
                this.onUpdate(event);
                break;
            }
            case PICKUP_HALF: {
                int amount = event.getCurrentItem().getAmount() / 2 + (event.getCurrentItem().getAmount() % 2 == 0 ? 0 : 1);
                this.onPickup(event, this.getCopyOfItemWithAmount(event.getCurrentItem(), amount));
                this.onUpdate(event);
                break;
            }
            case MOVE_TO_OTHER_INVENTORY: 
            case PICKUP_ALL: 
            case DROP_ALL_SLOT: {
                this.onPickup(event, event.getCurrentItem());
                this.onUpdate(event);
                break;
            }
            case SWAP_WITH_CURSOR: {
                this.onPickup(event, event.getCurrentItem());
                this.onPlace(event, event.getCursor());
                this.onUpdate(event);
                break;
            }
            case HOTBAR_SWAP: 
            case HOTBAR_MOVE_AND_READD: {
                this.onPickup(event, event.getCurrentItem());
                ItemStack hotbarItem = this.getItemStackFromHotKey(event);
                if (hotbarItem != null) {
                    this.onPlace(event, hotbarItem);
                }
                this.onUpdate(event);
                break;
            }
            case PLACE_ONE: {
                this.onPlace(event, this.getCopyOfItemWithAmount(event.getCursor(), 1));
                this.onUpdate(event);
                break;
            }
            case PLACE_SOME: {
                this.onPlace(event, this.getCopyOfItemWithAmount(event.getCursor(), event.getCursor().getMaxStackSize()));
                this.onUpdate(event);
                break;
            }
            case PLACE_ALL: {
                this.onPlace(event, event.getCursor());
                this.onUpdate(event);
                break;
            }
            default: {
                return;
            }
        }
        MCSchedulers.getGlobalScheduler().schedule(() -> {
            if (this.isEmpty(gui)) {
                gui.updateSlot(player, this.slot, this);
            }
        }, 1L);
    }

    private void handleEmptyInventoryClick(Player player, Gui gui, InventoryClickEvent event) {
        ItemStack cursor = event.getCursor();
        if (this.isItemNotEmpty(cursor)) {
            if (!this.canPlace(event, cursor)) {
                return;
            }
            ItemStack newCursor = null;
            if (event.isRightClick()) {
                if (cursor.getAmount() > 1) {
                    newCursor = this.getCopyOfItemWithAmount(cursor, cursor.getAmount() - 1);
                }
                cursor.setAmount(1);
            }
            event.setCursor(newCursor);
            this.onPlace(event, cursor);
            this.onUpdate(event);
            this.update(player, gui);
            return;
        }
        if (!event.getAction().equals((Object)InventoryAction.HOTBAR_MOVE_AND_READD)) {
            return;
        }
        ItemStack hotbarItem = this.getItemStackFromHotKey(event);
        assert (hotbarItem != null);
        if (!this.canPlace(event, hotbarItem)) {
            return;
        }
        this.onPlace(event, hotbarItem);
        this.onUpdate(event);
        this.update(player, gui);
    }

    @Override
    @Nullable
    public EventNode<InventoryEvent> getEventNode(Gui gui) {
        EventNode<InventoryEvent> eventNode = EventNode.value("advanced-gui-slot", BukkitEventFilter.INVENTORY, gui::isInventory);
        eventNode.addListener(InventoryClickEvent.class, event -> this.onInventoryClick(gui, (InventoryClickEvent)event));
        return eventNode;
    }

    private void onInventoryClick(Gui gui, InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        InventoryAction action = event.getAction();
        if (!action.equals((Object)InventoryAction.MOVE_TO_OTHER_INVENTORY)) {
            return;
        }
        if (event.getRawSlot() == event.getSlot()) {
            return;
        }
        ItemStack clickedItemStack = event.getCurrentItem();
        if (!this.isItemNotEmpty(clickedItemStack)) {
            return;
        }
        ItemStack itemStack = gui.getItem(this.slot);
        if (this.isEmpty(gui)) {
            if (!this.canPlace(event, clickedItemStack)) {
                return;
            }
            event.setCurrentItem(null);
            this.onPlace(event, clickedItemStack);
            this.onUpdate(event);
            this.update(player, gui);
        } else if (itemStack != null && this.compareSimilar(itemStack, clickedItemStack) && itemStack.getAmount() < itemStack.getType().getMaxStackSize()) {
            if (!this.canPlace(event, clickedItemStack)) {
                return;
            }
            int maxSize = itemStack.getType().getMaxStackSize();
            int transferSIze = itemStack.getAmount() + clickedItemStack.getAmount() > maxSize ? maxSize - itemStack.getAmount() : clickedItemStack.getAmount();
            ItemStack transferItemStack = this.getCopyOfItemWithAmount(clickedItemStack, transferSIze);
            clickedItemStack.setAmount(clickedItemStack.getAmount() - transferSIze);
            if (clickedItemStack.getAmount() == 0) {
                event.setCurrentItem(null);
            }
            event.setCurrentItem(clickedItemStack);
            this.onPlace(event, transferItemStack);
            this.onUpdate(event);
            this.update(player, gui);
        }
    }

    private boolean canPickup(InventoryClickEvent event, ItemStack itemStack) {
        return this.canPickupPredicate == null || this.canPickupPredicate.test(event, itemStack);
    }

    private boolean canPlace(InventoryClickEvent event, ItemStack itemStack) {
        return this.canPlacePredicate == null || this.canPlacePredicate.test(event, itemStack);
    }

    private void onPlace(InventoryClickEvent event, ItemStack itemStack) {
        if (this.currentItemStack == null) {
            this.currentItemStack = itemStack;
        } else {
            this.currentItemStack.setAmount(this.currentItemStack.getAmount() + itemStack.getAmount());
        }
        if (this.placeCallback != null) {
            this.placeCallback.accept(event, itemStack);
        }
        if (this.updateCallback != null) {
            this.updateCallback.accept(event, this.currentItemStack);
        }
    }

    private void onPickup(InventoryClickEvent event, ItemStack itemStack) {
        if (this.currentItemStack == null) {
            return;
        }
        int amount = this.currentItemStack.getAmount() - itemStack.getAmount();
        if (amount == 0) {
            this.currentItemStack = null;
        } else {
            this.currentItemStack.setAmount(amount);
        }
        if (this.pickupCallback != null) {
            this.pickupCallback.accept(event, itemStack);
        }
    }

    private void onUpdate(InventoryClickEvent event) {
        if (this.updateCallback != null) {
            this.updateCallback.accept(event, this.currentItemStack);
        }
    }

    private boolean checkPrePlace(@NotNull InventoryClickEvent event, InventoryAction action) {
        switch (action) {
            case HOTBAR_SWAP: 
            case HOTBAR_MOVE_AND_READD: {
                ItemStack hotbarItemStack = this.getItemStackFromHotKey(event);
                if (!this.isItemNotEmpty(hotbarItemStack) || this.canPlace(event, hotbarItemStack)) break;
                return true;
            }
            case SWAP_WITH_CURSOR: {
                ItemStack cursorItemStack = event.getCursor();
                if (!this.isItemNotEmpty(cursorItemStack) || this.canPlace(event, cursorItemStack)) break;
                return true;
            }
            case PLACE_ONE: 
            case PLACE_SOME: 
            case PLACE_ALL: {
                if (this.canPlace(event, event.getCursor())) break;
                return true;
            }
        }
        return false;
    }

    private boolean checkPrePickup(@NotNull InventoryClickEvent event, InventoryAction action) {
        switch (action) {
            case PLACE_ONE: 
            case PLACE_SOME: 
            case PLACE_ALL: {
                break;
            }
            default: {
                if (this.canPickup(event, event.getCurrentItem())) break;
                return true;
            }
        }
        return false;
    }

    private boolean compareSimilar(ItemStack item1, ItemStack item2) {
        boolean aNotEmpty = this.isItemNotEmpty(item1);
        boolean bNotEmpty = this.isItemNotEmpty(item2);
        if (aNotEmpty && bNotEmpty) {
            return item1.isSimilar(item2);
        }
        return !aNotEmpty && !bNotEmpty;
    }

    private ItemStack getCopyOfItemWithAmount(ItemStack item, int amount) {
        ItemStack result = item.clone();
        result.setAmount(amount);
        return result;
    }

    private boolean isItemEmpty(ItemStack itemStack) {
        return itemStack == null || XMaterial.AIR.isSimilar(itemStack) || itemStack.isSimilar(this.emptyItemStack);
    }

    private boolean isItemNotEmpty(ItemStack itemStack) {
        return !this.isItemEmpty(itemStack);
    }

    private ItemStack getItemStackFromHotKey(InventoryClickEvent event) {
        if (event.getHotbarButton() == -1) {
            return null;
        }
        return event.getWhoClicked().getInventory().getItem(event.getHotbarButton());
    }

    public ItemSelectorGuiSlot(int slot, ItemStack emptyItemStack, BiPredicate<InventoryClickEvent, ItemStack> canPickupPredicate, BiPredicate<InventoryClickEvent, ItemStack> canPlacePredicate, BiConsumer<InventoryClickEvent, ItemStack> pickupCallback, BiConsumer<InventoryClickEvent, ItemStack> placeCallback, BiConsumer<InventoryClickEvent, ItemStack> updateCallback, ItemStack currentItemStack) {
        this.slot = slot;
        this.emptyItemStack = emptyItemStack;
        this.canPickupPredicate = canPickupPredicate;
        this.canPlacePredicate = canPlacePredicate;
        this.pickupCallback = pickupCallback;
        this.placeCallback = placeCallback;
        this.updateCallback = updateCallback;
        this.currentItemStack = currentItemStack;
    }

    public static class Builder {
        private final int slot;
        private ItemStack emptyItemStack = new ItemStack(Material.AIR);
        private ItemStack currentItemStack;
        private BiPredicate<InventoryClickEvent, ItemStack> canPickupPredicate;
        private BiPredicate<InventoryClickEvent, ItemStack> canPlacePredicate;
        private BiConsumer<InventoryClickEvent, ItemStack> pickupCallback;
        private BiConsumer<InventoryClickEvent, ItemStack> placeCallback;
        private BiConsumer<InventoryClickEvent, ItemStack> updateCallback;

        public Builder(Pane pane, int slot) {
            this.slot = pane.getMapping().getSlot(slot);
        }

        public Builder(Pane pane, int x, int y) {
            this.slot = pane.getMapping().getSlot(x, y);
        }

        public Builder emptyItem(ItemStack emptyItemStack) {
            this.emptyItemStack = emptyItemStack;
            return this;
        }

        public Builder currentItem(ItemStack currentItemStack) {
            this.currentItemStack = currentItemStack;
            return this;
        }

        public Builder canPickupPredicate(BiPredicate<InventoryClickEvent, ItemStack> prePickupPredicate) {
            this.canPickupPredicate = prePickupPredicate;
            return this;
        }

        public Builder canPlacePredicate(BiPredicate<InventoryClickEvent, ItemStack> prePutPredicate) {
            this.canPlacePredicate = prePutPredicate;
            return this;
        }

        public Builder pickupCallback(BiConsumer<InventoryClickEvent, ItemStack> pickupCallback) {
            this.pickupCallback = pickupCallback;
            return this;
        }

        public Builder placeCallback(BiConsumer<InventoryClickEvent, ItemStack> putCallback) {
            this.placeCallback = putCallback;
            return this;
        }

        public Builder updateCallback(BiConsumer<InventoryClickEvent, ItemStack> updateCallback) {
            this.updateCallback = updateCallback;
            return this;
        }

        public Builder canPickupPredicate(Predicate<ItemStack> prePickupPredicate) {
            this.canPickupPredicate = (event, itemStack) -> prePickupPredicate.test((ItemStack)itemStack);
            return this;
        }

        public Builder canPlacePredicate(Predicate<ItemStack> prePutPredicate) {
            this.canPlacePredicate = (event, itemStack) -> prePutPredicate.test((ItemStack)itemStack);
            return this;
        }

        public Builder pickupCallback(Consumer<ItemStack> pickupCallback) {
            this.pickupCallback = (event, itemStack) -> pickupCallback.accept((ItemStack)itemStack);
            return this;
        }

        public Builder placeCallback(Consumer<ItemStack> putCallback) {
            this.placeCallback = (event, itemStack) -> putCallback.accept((ItemStack)itemStack);
            return this;
        }

        public Builder updateCallback(Consumer<ItemStack> updateCallback) {
            this.updateCallback = (event, itemStack) -> updateCallback.accept((ItemStack)itemStack);
            return this;
        }

        public ItemSelectorGuiSlot build() {
            return new ItemSelectorGuiSlot(this.slot, this.emptyItemStack, this.canPickupPredicate, this.canPlacePredicate, this.pickupCallback, this.placeCallback, this.updateCallback, this.currentItemStack);
        }
    }
}

