/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.listener;

import com.google.common.collect.ImmutableList;
import info.cho.passwords.fairy.log.Log;
import info.cho.passwords.fairy.util.terminable.Terminable;
import info.cho.passwords.fairy.util.terminable.TerminableConsumer;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ListenerSubscription
implements Terminable {
    private final AtomicBoolean registered;
    private final List<Listener> listeners;
    private final Plugin plugin;
    private final TerminableConsumer terminableConsumer;

    public ListenerSubscription(Listener[] listeners, Plugin plugin, @Nullable TerminableConsumer terminableConsumer) {
        this.listeners = ImmutableList.copyOf((Object[])listeners);
        this.registered = new AtomicBoolean(false);
        this.plugin = plugin;
        this.terminableConsumer = terminableConsumer;
    }

    public void register() {
        if (!this.registered.compareAndSet(false, true)) {
            return;
        }
        this.listeners.forEach(listener -> {
            try {
                Bukkit.getPluginManager().registerEvents(listener, this.plugin);
            }
            catch (Throwable throwable) {
                Log.error("Error while registering listener " + listener.getClass().getName(), throwable, new Object[0]);
            }
        });
        if (this.terminableConsumer != null) {
            this.terminableConsumer.bind(this);
        }
    }

    @Override
    public void close() {
        if (!this.registered.compareAndSet(true, false)) {
            return;
        }
        this.listeners.forEach(HandlerList::unregisterAll);
    }
}

