/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.mc;

import info.cho.passwords.fairy.bukkit.mc.entity.BukkitDataWatcherConverter;
import info.cho.passwords.fairy.bukkit.util.BukkitPos;
import info.cho.passwords.fairy.event.EventNode;
import info.cho.passwords.fairy.event.GlobalEventNode;
import info.cho.passwords.fairy.libs.packetevents.protocol.entity.data.EntityData;
import info.cho.passwords.fairy.mc.MCEntity;
import info.cho.passwords.fairy.mc.MCEventFilter;
import info.cho.passwords.fairy.mc.MCWorld;
import info.cho.passwords.fairy.mc.event.trait.MCEntityEvent;
import info.cho.passwords.fairy.mc.scheduler.MCScheduler;
import info.cho.passwords.fairy.mc.scheduler.MCSchedulerProvider;
import info.cho.passwords.fairy.mc.util.Position;
import info.cho.passwords.fairy.util.exceptionally.ThrowingSupplier;
import java.util.List;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class BukkitMCEntity
implements MCEntity {
    protected final MCSchedulerProvider mcSchedulerProvider;
    private final BukkitDataWatcherConverter dataWatcherConverter;
    private final EventNode<MCEntityEvent> eventNode;
    private Entity entity;
    protected MCScheduler scheduler;

    public BukkitMCEntity(BukkitDataWatcherConverter dataWatcherConverter, MCSchedulerProvider mcSchedulerProvider) {
        this.mcSchedulerProvider = mcSchedulerProvider;
        this.dataWatcherConverter = dataWatcherConverter;
        this.eventNode = GlobalEventNode.get().map(this, MCEventFilter.ENTITY);
    }

    public BukkitMCEntity(Entity entity, BukkitDataWatcherConverter dataWatcherConverter, MCSchedulerProvider mcSchedulerProvider) {
        this(dataWatcherConverter, mcSchedulerProvider);
        this.entity = entity;
    }

    @Override
    public MCWorld getWorld() {
        return MCWorld.from(this.entity.getWorld());
    }

    @Override
    public UUID getUUID() {
        return this.entity.getUniqueId();
    }

    @Override
    public int getId() {
        return this.entity.getEntityId();
    }

    @Override
    public boolean teleport(Position pos) {
        return this.entity.teleport(BukkitPos.toBukkitLocation(pos));
    }

    @Override
    @NotNull
    public EventNode<MCEntityEvent> getEventNode() {
        return this.eventNode;
    }

    @Override
    public Position getPosition() {
        return BukkitPos.toMCPos(this.entity.getLocation());
    }

    @Override
    @NotNull
    public List<EntityData> data() {
        return ThrowingSupplier.sneaky(() -> this.dataWatcherConverter.convert(this.entity)).get();
    }

    @Override
    @NotNull
    public MCScheduler getScheduler() {
        if (this.scheduler == null) {
            this.scheduler = this.mcSchedulerProvider.getEntityScheduler(this.entity);
        }
        return this.scheduler;
    }

    @Override
    public <T> T as(@NotNull Class<T> playerClass) {
        if (!playerClass.isInstance(this.entity)) {
            throw new ClassCastException();
        }
        return playerClass.cast(this.entity);
    }

    @Override
    public void setNative(@NotNull Object nativeObject) {
        this.entity = (Entity)nativeObject;
    }
}

