/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.mc;

import com.destroystokyo.paper.profile.ProfileProperty;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import info.cho.passwords.fairy.mc.MCGameProfile;
import info.cho.passwords.fairy.util.EquivalentConverter;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;

public class BukkitMCGameProfile
implements MCGameProfile {
    public static final EquivalentConverter<MCGameProfile> CONVERTER = new EquivalentConverter<MCGameProfile>(){

        @Override
        public Object getGeneric(MCGameProfile specific) {
            return ((BukkitMCGameProfile)specific).gameProfile;
        }

        @Override
        public MCGameProfile getSpecific(Object generic) {
            if (!(generic instanceof GameProfile)) {
                throw new ClassCastException();
            }
            return new BukkitMCGameProfile((GameProfile)generic);
        }

        @Override
        public Class<MCGameProfile> getSpecificType() {
            return MCGameProfile.class;
        }
    };
    private final GameProfile gameProfile;
    private final PropertySet properties;

    public BukkitMCGameProfile(String name, UUID uuid) {
        this(new GameProfile(uuid, name));
    }

    public BukkitMCGameProfile(GameProfile gameProfile) {
        this.gameProfile = gameProfile;
        this.properties = new PropertySet();
    }

    @Override
    public String getName() {
        return this.gameProfile.getName();
    }

    @Override
    public UUID getUuid() {
        return this.gameProfile.getId();
    }

    @Override
    @NotNull
    public Set<info.cho.passwords.fairy.mc.util.Property> getProperties() {
        return this.properties;
    }

    @Override
    public boolean hasProperty(String property) {
        return this.gameProfile.getProperties().containsKey((Object)property);
    }

    @Override
    public void setProperty(info.cho.passwords.fairy.mc.util.Property property) {
        String name = property.getName();
        PropertyMap properties = this.gameProfile.getProperties();
        properties.removeAll((Object)name);
        properties.put((Object)name, (Object)new Property(name, property.getValue(), property.getSignature()));
    }

    @Override
    public void setProperties(Collection<info.cho.passwords.fairy.mc.util.Property> properties) {
        properties.forEach(this::setProperty);
    }

    @Override
    public void clearProperties() {
        this.gameProfile.getProperties().clear();
    }

    @Override
    public boolean removeProperty(String property) {
        return !this.gameProfile.getProperties().removeAll((Object)property).isEmpty();
    }

    private static info.cho.passwords.fairy.mc.util.Property toBukkit(Property property) {
        return new info.cho.passwords.fairy.mc.util.Property(property.getName(), property.getValue(), property.getSignature());
    }

    private class PropertySet
    extends AbstractSet<info.cho.passwords.fairy.mc.util.Property> {
        private PropertySet() {
        }

        @Override
        @Nonnull
        public Iterator<info.cho.passwords.fairy.mc.util.Property> iterator() {
            return new ProfilePropertyIterator(BukkitMCGameProfile.this.gameProfile.getProperties().values().iterator());
        }

        @Override
        public int size() {
            return BukkitMCGameProfile.this.gameProfile.getProperties().size();
        }

        @Override
        public boolean add(info.cho.passwords.fairy.mc.util.Property property) {
            BukkitMCGameProfile.this.setProperty(property);
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends info.cho.passwords.fairy.mc.util.Property> c) {
            BukkitMCGameProfile.this.setProperties(c);
            return true;
        }

        @Override
        public boolean contains(Object o) {
            return o instanceof ProfileProperty && BukkitMCGameProfile.this.gameProfile.getProperties().containsKey((Object)((ProfileProperty)o).getName());
        }

        private class ProfilePropertyIterator
        implements Iterator<info.cho.passwords.fairy.mc.util.Property> {
            private final Iterator<Property> iterator;

            ProfilePropertyIterator(Iterator<Property> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public info.cho.passwords.fairy.mc.util.Property next() {
                return BukkitMCGameProfile.toBukkit(this.iterator.next());
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        }
    }
}

