/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.mc;

import info.cho.passwords.fairy.bukkit.mc.BukkitMCEntity;
import info.cho.passwords.fairy.bukkit.mc.entity.BukkitDataWatcherConverter;
import info.cho.passwords.fairy.bukkit.mc.operator.BukkitMCPlayerOperator;
import info.cho.passwords.fairy.bukkit.util.PlayerLocaleUtil;
import info.cho.passwords.fairy.libs.kyori.adventure.audience.Audience;
import info.cho.passwords.fairy.libs.kyori.adventure.platform.bukkit.BukkitAudiences;
import info.cho.passwords.fairy.libs.kyori.adventure.text.Component;
import info.cho.passwords.fairy.mc.GameMode;
import info.cho.passwords.fairy.mc.MCGameProfile;
import info.cho.passwords.fairy.mc.MCPlayer;
import info.cho.passwords.fairy.mc.MCServer;
import info.cho.passwords.fairy.mc.scheduler.MCScheduler;
import info.cho.passwords.fairy.mc.scheduler.MCSchedulerProvider;
import info.cho.passwords.fairy.mc.util.AudienceProxy;
import info.cho.passwords.fairy.mc.version.MCVersion;
import info.cho.passwords.fairy.mc.version.MCVersionMapping;
import info.cho.passwords.fairy.mc.version.MCVersionMappingRegistry;
import io.netty.channel.Channel;
import java.net.InetAddress;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class BukkitMCPlayer
extends BukkitMCEntity
implements AudienceProxy,
MCPlayer {
    private Player player;
    private MCServer server;
    private Channel channel;
    private Audience audience;
    private final UUID uuid;
    private final String name;
    private final InetAddress address;
    private final BukkitAudiences audiences;
    private final BukkitMCPlayerOperator operator;
    private final MCVersionMappingRegistry versionMappingRegistry;

    public BukkitMCPlayer(UUID uuid, String name, InetAddress address, MCServer server, BukkitAudiences bukkitAudiences, BukkitDataWatcherConverter dataWatcherConverter, BukkitMCPlayerOperator operator, MCVersionMappingRegistry versionMappingRegistry, MCSchedulerProvider mcSchedulerProvider) {
        super(dataWatcherConverter, mcSchedulerProvider);
        this.uuid = uuid;
        this.name = name;
        this.address = address;
        this.server = server;
        this.audiences = bukkitAudiences;
        this.operator = operator;
        this.versionMappingRegistry = versionMappingRegistry;
    }

    @Override
    public InetAddress getAddress() {
        return this.address;
    }

    @Override
    public MCVersion getVersion() {
        MCVersion version = this.server.getVersion();
        MCVersionMapping mapping = this.versionMappingRegistry.findMapping(version);
        return mapping.toMCVersion();
    }

    @Override
    public int getPing() {
        return this.operator.getPing(this.player);
    }

    @Override
    public GameMode getGameMode() {
        return GameMode.valueOf(this.player.getGameMode().name());
    }

    @Override
    public MCGameProfile getGameProfile() {
        return this.operator.getGameProfile(this.player);
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public int getId() {
        return this.player.getEntityId();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isOnline() {
        return this.player.isOnline();
    }

    @Override
    public Component getDisplayName() {
        return this.operator.getDisplayName(this.player);
    }

    @Override
    public void setDisplayName(Component component) {
        this.operator.setDisplayName(this, component);
    }

    @Override
    public String getGameLocale() {
        return PlayerLocaleUtil.getLocale(this.player);
    }

    @Override
    public Channel getChannel() {
        if (this.channel == null) {
            this.channel = this.operator.getChannel(this.player);
        }
        return this.channel;
    }

    @Override
    public <T> T as(@NotNull Class<T> playerClass) {
        if (!playerClass.isInstance(this.player)) {
            throw new ClassCastException();
        }
        return playerClass.cast(this.player);
    }

    @Override
    public void setNative(@NotNull Object nativeObject) {
        super.setNative(nativeObject);
        this.player = (Player)nativeObject;
        this.audience = this.audiences.player(this.player);
    }

    @Override
    @NotNull
    public MCScheduler getScheduler() {
        if (this.scheduler == null) {
            this.scheduler = this.mcSchedulerProvider.getEntityScheduler(this.player);
        }
        return this.scheduler;
    }

    @Override
    public Audience audience() {
        return this.audience;
    }
}

