/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.mc.operator;

import info.cho.passwords.fairy.bukkit.mc.BukkitMCPlayer;
import info.cho.passwords.fairy.bukkit.mc.entity.BukkitDataWatcherConverter;
import info.cho.passwords.fairy.bukkit.mc.operator.BukkitMCPlayerOperator;
import info.cho.passwords.fairy.bukkit.util.Players;
import info.cho.passwords.fairy.libs.kyori.adventure.platform.bukkit.BukkitAudiences;
import info.cho.passwords.fairy.mc.MCPlayer;
import info.cho.passwords.fairy.mc.MCServer;
import info.cho.passwords.fairy.mc.registry.player.MCPlayerPlatformOperator;
import info.cho.passwords.fairy.mc.scheduler.MCSchedulerProvider;
import info.cho.passwords.fairy.mc.version.MCVersionMappingRegistry;
import java.net.InetAddress;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class BukkitMCPlayerPlatformOperator
implements MCPlayerPlatformOperator {
    private final MCServer mcServer;
    private final BukkitAudiences bukkitAudiences;
    private final BukkitDataWatcherConverter dataWatcherConverter;
    private final BukkitMCPlayerOperator playerOperator;
    private final MCSchedulerProvider mcSchedulerProvider;
    protected final MCVersionMappingRegistry versionMappingRegistry;

    @Override
    public UUID getUniqueId(@NotNull Object platformPlayer) {
        return Players.tryGetUniqueId(platformPlayer);
    }

    @Override
    public String getName(@NotNull Object platformPlayer) {
        if (platformPlayer instanceof String) {
            return (String)platformPlayer;
        }
        if (platformPlayer instanceof Player) {
            return ((Player)platformPlayer).getName();
        }
        throw new IllegalArgumentException(platformPlayer.getClass().getName());
    }

    @Override
    public List<MCPlayer> loadOnlinePlayers() {
        return Bukkit.getOnlinePlayers().stream().map(player -> {
            MCPlayer mcPlayer = this.create(player.getName(), player.getUniqueId(), Objects.requireNonNull(player.getAddress()).getAddress());
            mcPlayer.setNative(player);
            return mcPlayer;
        }).collect(Collectors.toList());
    }

    @Override
    public MCPlayer create(@NotNull String name, @NotNull UUID uuid, @NotNull InetAddress address) {
        return new BukkitMCPlayer(uuid, name, address, this.mcServer, this.bukkitAudiences, this.dataWatcherConverter, this.playerOperator, this.versionMappingRegistry, this.mcSchedulerProvider);
    }

    public BukkitMCPlayerPlatformOperator(MCServer mcServer, BukkitAudiences bukkitAudiences, BukkitDataWatcherConverter dataWatcherConverter, BukkitMCPlayerOperator playerOperator, MCSchedulerProvider mcSchedulerProvider, MCVersionMappingRegistry versionMappingRegistry) {
        this.mcServer = mcServer;
        this.bukkitAudiences = bukkitAudiences;
        this.dataWatcherConverter = dataWatcherConverter;
        this.playerOperator = playerOperator;
        this.mcSchedulerProvider = mcSchedulerProvider;
        this.versionMappingRegistry = versionMappingRegistry;
    }
}

