/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.metadata;

import com.google.common.collect.ImmutableMap;
import info.cho.passwords.fairy.bukkit.mc.EntityUUIDFinder;
import info.cho.passwords.fairy.bukkit.metadata.type.BlockMetadataRegistry;
import info.cho.passwords.fairy.bukkit.metadata.type.EntityMetadataRegistry;
import info.cho.passwords.fairy.bukkit.metadata.type.PlayerMetadataRegistry;
import info.cho.passwords.fairy.bukkit.metadata.type.WorldMetadataRegistry;
import info.cho.passwords.fairy.container.Containers;
import info.cho.passwords.fairy.mc.util.BlockPosition;
import info.cho.passwords.fairy.metadata.AbstractMetadataRegistry;
import info.cho.passwords.fairy.metadata.CommonMetadataRegistries;
import info.cho.passwords.fairy.metadata.MetadataKey;
import info.cho.passwords.fairy.metadata.MetadataMap;
import info.cho.passwords.fairy.metadata.MetadataRegistry;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

final class BukkitMetadataRegistries {
    private final PlayerMetadataRegistry playerRegistry = new PlayerRegistry(CommonMetadataRegistries.PLAYERS);
    private final EntityMetadataRegistry entityRegistry = new EntityRegistry();
    private final BlockMetadataRegistry blockRegistry = new BlockRegistry();
    private final WorldMetadataRegistry worldRegistry = new WorldRegistry();
    private final MetadataRegistry<?>[] values = new MetadataRegistry[]{this.playerRegistry, this.entityRegistry, this.blockRegistry, this.worldRegistry};

    BukkitMetadataRegistries() {
    }

    MetadataRegistry<?>[] values() {
        return this.values;
    }

    public PlayerMetadataRegistry getPlayerRegistry() {
        return this.playerRegistry;
    }

    public EntityMetadataRegistry getEntityRegistry() {
        return this.entityRegistry;
    }

    public BlockMetadataRegistry getBlockRegistry() {
        return this.blockRegistry;
    }

    public WorldMetadataRegistry getWorldRegistry() {
        return this.worldRegistry;
    }

    private static final class PlayerRegistry
    implements PlayerMetadataRegistry {
        private AbstractMetadataRegistry<UUID> uuids;

        private PlayerRegistry(AbstractMetadataRegistry<UUID> uuids) {
            this.uuids = uuids;
        }

        @Override
        @Nonnull
        public MetadataMap provide(@Nonnull Player player) {
            Objects.requireNonNull(player, "player");
            return this.provide(player.getUniqueId());
        }

        @Override
        @Nonnull
        public Optional<MetadataMap> get(@Nonnull Player player) {
            Objects.requireNonNull(player, "player");
            return this.get(player.getUniqueId());
        }

        @Override
        @Nonnull
        public <K> Map<Player, K> getAllWithKey(@Nonnull MetadataKey<K> key) {
            Objects.requireNonNull(key, "key");
            ImmutableMap.Builder ret = ImmutableMap.builder();
            this.uuids.cache().forEach((uuid, map) -> map.get(key).ifPresent(t -> {
                Player player = Bukkit.getPlayer((UUID)uuid);
                if (player != null) {
                    ret.put((Object)player, t);
                }
            }));
            return ret.build();
        }

        @Override
        @NotNull
        public MetadataMap provide(@NotNull UUID id) {
            return this.uuids.provide(id);
        }

        @Override
        @NotNull
        public Optional<MetadataMap> get(@NotNull UUID id) {
            return this.uuids.get(id);
        }

        @Override
        public void remove(@NotNull UUID id) {
            this.uuids.remove(id);
        }

        @Override
        public void cleanup() {
            this.uuids.cleanup();
        }

        @Override
        public void destroy() {
            this.uuids.destroy();
        }

        @Override
        public Map<UUID, MetadataMap> cache() {
            return this.uuids.cache();
        }
    }

    private static final class EntityRegistry
    extends AbstractMetadataRegistry<UUID>
    implements EntityMetadataRegistry {
        private EntityRegistry() {
        }

        @Override
        @Nonnull
        public MetadataMap provide(@Nonnull Entity entity) {
            Objects.requireNonNull(entity, "entity");
            return this.provide(entity.getUniqueId());
        }

        @Override
        @Nonnull
        public Optional<MetadataMap> get(@Nonnull Entity entity) {
            Objects.requireNonNull(entity, "entity");
            return this.get(entity.getUniqueId());
        }

        @Override
        @Nonnull
        public <K> Map<Entity, K> getAllWithKey(@Nonnull MetadataKey<K> key) {
            Objects.requireNonNull(key, "key");
            ImmutableMap.Builder ret = ImmutableMap.builder();
            this.cache().forEach((uuid, map) -> map.get(key).ifPresent(t -> {
                EntityUUIDFinder entityUUIDFinder = Containers.get(EntityUUIDFinder.class);
                Entity entity = entityUUIDFinder.findEntityByUuid((UUID)uuid);
                if (entity != null) {
                    ret.put((Object)entity, t);
                }
            }));
            return ret.build();
        }
    }

    private static final class BlockRegistry
    extends AbstractMetadataRegistry<BlockPosition>
    implements BlockMetadataRegistry {
        private BlockRegistry() {
        }

        @Override
        @Nonnull
        public MetadataMap provide(@Nonnull Block block) {
            Objects.requireNonNull(block, "block");
            return this.provide(new BlockPosition(block.getX(), block.getY(), block.getZ()));
        }

        @Override
        @Nonnull
        public Optional<MetadataMap> get(@Nonnull Block block) {
            Objects.requireNonNull(block, "block");
            return this.get(new BlockPosition(block.getX(), block.getY(), block.getZ()));
        }

        @Override
        @Nonnull
        public <K> Map<BlockPosition, K> getAllWithKey(@Nonnull MetadataKey<K> key) {
            Objects.requireNonNull(key, "key");
            ImmutableMap.Builder ret = ImmutableMap.builder();
            this.cache().forEach((pos, map) -> map.get(key).ifPresent(t -> ret.put(pos, t)));
            return ret.build();
        }
    }

    private static final class WorldRegistry
    extends AbstractMetadataRegistry<UUID>
    implements WorldMetadataRegistry {
        private WorldRegistry() {
        }

        @Override
        @Nonnull
        public MetadataMap provide(@Nonnull World world) {
            Objects.requireNonNull(world, "world");
            return this.provide(world.getUID());
        }

        @Override
        @Nonnull
        public Optional<MetadataMap> get(@Nonnull World world) {
            Objects.requireNonNull(world, "world");
            return this.get(world.getUID());
        }

        @Override
        @Nonnull
        public <K> Map<World, K> getAllWithKey(@Nonnull MetadataKey<K> key) {
            Objects.requireNonNull(key, "key");
            ImmutableMap.Builder ret = ImmutableMap.builder();
            this.cache().forEach((uuid, map) -> map.get(key).ifPresent(t -> {
                World world = Bukkit.getWorld((UUID)uuid);
                if (world != null) {
                    ret.put((Object)world, t);
                }
            }));
            return ret.build();
        }
    }
}

