/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.metadata;

import info.cho.passwords.fairy.bukkit.metadata.BukkitMetadataRegistries;
import info.cho.passwords.fairy.bukkit.metadata.type.BlockMetadataRegistry;
import info.cho.passwords.fairy.bukkit.metadata.type.EntityMetadataRegistry;
import info.cho.passwords.fairy.bukkit.metadata.type.PlayerMetadataRegistry;
import info.cho.passwords.fairy.bukkit.metadata.type.WorldMetadataRegistry;
import info.cho.passwords.fairy.mc.util.BlockPosition;
import info.cho.passwords.fairy.metadata.MetadataKey;
import info.cho.passwords.fairy.metadata.MetadataMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public final class Metadata {
    private static BukkitMetadataRegistries registries;

    static BukkitMetadataRegistries getRegistries() {
        if (registries == null) {
            registries = new BukkitMetadataRegistries();
        }
        return registries;
    }

    public static void destroy() {
        registries = null;
    }

    public static PlayerMetadataRegistry players() {
        return Metadata.getRegistries().getPlayerRegistry();
    }

    public static EntityMetadataRegistry entities() {
        return Metadata.getRegistries().getEntityRegistry();
    }

    public static BlockMetadataRegistry blocks() {
        return Metadata.getRegistries().getBlockRegistry();
    }

    public static WorldMetadataRegistry worlds() {
        return Metadata.getRegistries().getWorldRegistry();
    }

    @Nonnull
    public static MetadataMap provide(@Nonnull Object obj) {
        Objects.requireNonNull(obj, "obj");
        if (obj instanceof Player) {
            return Metadata.provideForPlayer((Player)obj);
        }
        if (obj instanceof UUID) {
            return Metadata.provideForPlayer((UUID)obj);
        }
        if (obj instanceof Entity) {
            return Metadata.provideForEntity((Entity)obj);
        }
        if (obj instanceof Block) {
            return Metadata.provideForBlock((Block)obj);
        }
        if (obj instanceof World) {
            return Metadata.provideForWorld((World)obj);
        }
        throw new IllegalArgumentException("Unknown object type: " + obj.getClass());
    }

    @Nonnull
    public static Optional<MetadataMap> get(@Nonnull Object obj) {
        Objects.requireNonNull(obj, "obj");
        if (obj instanceof Player) {
            return Metadata.getForPlayer((Player)obj);
        }
        if (obj instanceof UUID) {
            return Metadata.getForPlayer((UUID)obj);
        }
        if (obj instanceof Entity) {
            return Metadata.getForEntity((Entity)obj);
        }
        if (obj instanceof Block) {
            return Metadata.getForBlock((Block)obj);
        }
        if (obj instanceof World) {
            return Metadata.getForWorld((World)obj);
        }
        throw new IllegalArgumentException("Unknown object type: " + obj.getClass());
    }

    @Nonnull
    public static MetadataMap provideForPlayer(@Nonnull UUID uuid) {
        return Metadata.players().provide(uuid);
    }

    @Nonnull
    public static MetadataMap provideForPlayer(@Nonnull Player player) {
        return Metadata.players().provide(player);
    }

    @Nonnull
    public static Optional<MetadataMap> getForPlayer(@Nonnull UUID uuid) {
        return Metadata.players().get(uuid);
    }

    @Nonnull
    public static Optional<MetadataMap> getForPlayer(@Nonnull Player player) {
        return Metadata.players().get(player);
    }

    @Nonnull
    public static <T> Map<Player, T> lookupPlayersWithKey(@Nonnull MetadataKey<T> key) {
        return Metadata.players().getAllWithKey(key);
    }

    @Nonnull
    public static MetadataMap provideForEntity(@Nonnull UUID uuid) {
        return Metadata.entities().provide(uuid);
    }

    @Nonnull
    public static MetadataMap provideForEntity(@Nonnull Entity entity) {
        return Metadata.entities().provide(entity);
    }

    @Nonnull
    public static Optional<MetadataMap> getForEntity(@Nonnull UUID uuid) {
        return Metadata.entities().get(uuid);
    }

    @Nonnull
    public static Optional<MetadataMap> getForEntity(@Nonnull Entity entity) {
        return Metadata.entities().get(entity);
    }

    @Nonnull
    public static <T> Map<Entity, T> lookupEntitiesWithKey(@Nonnull MetadataKey<T> key) {
        return Metadata.entities().getAllWithKey(key);
    }

    @Nonnull
    public static MetadataMap provideForBlock(@Nonnull BlockPosition block) {
        return Metadata.blocks().provide(block);
    }

    @Nonnull
    public static MetadataMap provideForBlock(@Nonnull Block block) {
        return Metadata.blocks().provide(block);
    }

    @Nonnull
    public static Optional<MetadataMap> getForBlock(@Nonnull BlockPosition block) {
        return Metadata.blocks().get(block);
    }

    @Nonnull
    public static Optional<MetadataMap> getForBlock(@Nonnull Block block) {
        return Metadata.blocks().get(block);
    }

    @Nonnull
    public static <T> Map<BlockPosition, T> lookupBlocksWithKey(@Nonnull MetadataKey<T> key) {
        return Metadata.blocks().getAllWithKey(key);
    }

    @Nonnull
    public static MetadataMap provideForWorld(@Nonnull UUID uid) {
        return Metadata.worlds().provide(uid);
    }

    @Nonnull
    public static MetadataMap provideForWorld(@Nonnull World world) {
        return Metadata.worlds().provide(world);
    }

    @Nonnull
    public static Optional<MetadataMap> getForWorld(@Nonnull UUID uid) {
        return Metadata.worlds().get(uid);
    }

    @Nonnull
    public static Optional<MetadataMap> getForWorld(@Nonnull World world) {
        return Metadata.worlds().get(world);
    }

    @Nonnull
    public static <T> Map<World, T> lookupWorldsWithKey(@Nonnull MetadataKey<T> key) {
        return Metadata.worlds().getAllWithKey(key);
    }

    private Metadata() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }
}

