/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.player.movement.impl;

import info.cho.passwords.fairy.bukkit.listener.events.EventSubscribeBuilder;
import info.cho.passwords.fairy.bukkit.listener.events.EventSubscription;
import info.cho.passwords.fairy.bukkit.listener.events.Events;
import info.cho.passwords.fairy.bukkit.player.movement.MovementListener;
import info.cho.passwords.fairy.bukkit.player.movement.impl.AbstractMovementImplementation;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

public class BukkitMovementImplementation
extends AbstractMovementImplementation {
    private EventSubscription<PlayerMoveEvent> subscription;

    public BukkitMovementImplementation(MovementListener movementListener) {
        super(movementListener);
    }

    @Override
    public void register(Plugin plugin) {
        EventSubscribeBuilder<PlayerMoveEvent> subscribeBuilder = Events.subscribe(PlayerMoveEvent.class).handleSubClasses().listen((handler, event) -> {
            Player player = event.getPlayer();
            Location from = event.getFrom();
            Location to = event.getTo();
            this.updateLocation(player, from, to);
            this.updateRotation(player, from, to);
        });
        if (this.isIgnoreSameBlock()) {
            if (this.isIgnoreSameY()) {
                subscribeBuilder.filter(Events.IGNORE_SAME_BLOCK_AND_Y);
            } else {
                subscribeBuilder.filter(Events.IGNORE_SAME_BLOCK);
            }
        }
        this.subscription = subscribeBuilder.build(plugin);
    }

    @Override
    public void unregister() {
        this.subscription.unregister();
    }
}

