/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.reflection.accessor;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import info.cho.passwords.fairy.bukkit.reflection.resolver.ResolverQuery;
import info.cho.passwords.fairy.util.AccessUtil;
import info.cho.passwords.fairy.util.Utility;
import info.cho.passwords.fairy.util.exceptionally.ThrowingSupplier;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;

public class ClassAccessorCache {
    private static final LoadingCache<Class<?>, ClassAccessorCache> CLASS_ACCESSORS = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build(new CacheLoader<Class<?>, ClassAccessorCache>(){

        public ClassAccessorCache load(Class<?> key) throws Exception {
            return new ClassAccessorCache(key);
        }
    });
    private final Class<?> parentClass;
    private final Map<ResolverQuery, Method> methodCache;
    private final Map<ResolverQuery, Field> fieldCache;

    public static ClassAccessorCache get(Class<?> parentClass) {
        return ThrowingSupplier.unchecked(() -> (ClassAccessorCache)CLASS_ACCESSORS.get((Object)parentClass)).get();
    }

    public ClassAccessorCache(Class<?> parentClass) {
        this.parentClass = parentClass;
        this.methodCache = new ConcurrentHashMap<ResolverQuery, Method>();
        this.fieldCache = new ConcurrentHashMap<ResolverQuery, Field>();
    }

    public Method resolveMethod(ResolverQuery query) throws ReflectiveOperationException {
        if (this.methodCache.containsKey(query)) {
            return this.methodCache.get(query);
        }
        int currentIndex = 0;
        Method result = null;
        for (Method method : this.parentClass.getDeclaredMethods()) {
            if (query.getReturnType() != null && !Utility.wrapPrimitive(query.getReturnType()).equals(Utility.wrapPrimitive(method.getReturnType())) || query.getName() != null && !method.getName().equals(query.getName()) || query.getModifierOptions() != null && !query.getModifierOptions().matches(method.getModifiers()) || query.getTypes() != null && query.getTypes().length > 0 && !Utility.isParametersEquals(query.getTypes(), method.getParameterTypes())) continue;
            if (query.getIndex() == -2) {
                result = method;
                continue;
            }
            if (query.getIndex() >= 0 && query.getIndex() != currentIndex++) continue;
            return this.cache(query, method);
        }
        if (result != null) {
            return this.cache(query, result);
        }
        throw new NoSuchMethodException();
    }

    public Field resolveField(ResolverQuery query) throws ReflectiveOperationException {
        if (this.fieldCache.containsKey(query)) {
            return this.fieldCache.get(query);
        }
        if (query.isSupertypes()) {
            for (Class<?> superClass : Utility.getSuperClasses(this.parentClass)) {
                Field field = this.resolveFieldByClass(superClass, query);
                if (field == null) continue;
                return field;
            }
        } else {
            Field field = this.resolveFieldByClass(this.parentClass, query);
            if (field != null) {
                return field;
            }
        }
        throw new NoSuchFieldException();
    }

    @Nullable
    private Field resolveFieldByClass(Class<?> aClass, ResolverQuery query) throws ReflectiveOperationException {
        Field result = null;
        int currentIndex = 0;
        for (Field field : aClass.getDeclaredFields()) {
            Type[] genericTypes;
            if (query.getName() != null && !field.getName().equals(query.getName()) || query.getReturnType() != null && !Utility.wrapPrimitive(query.getReturnType()).equals(Utility.wrapPrimitive(field.getType())) || query.getModifierOptions() != null && !query.getModifierOptions().matches(field.getModifiers()) || query.getTypes() != null && query.getTypes().length > 0 && ((genericTypes = Utility.getGenericTypes(field)) == null || !Utility.isParametersEquals(genericTypes, query.getTypes()))) continue;
            if (query.getIndex() == -2) {
                result = field;
                continue;
            }
            if (query.getIndex() >= 0 && query.getIndex() != currentIndex++) continue;
            return this.cache(query, field);
        }
        if (result != null) {
            return this.cache(query, result);
        }
        return result;
    }

    private Method cache(ResolverQuery query, Method method) throws ReflectiveOperationException {
        AccessUtil.setAccessible(method);
        this.methodCache.put(query, method);
        return method;
    }

    private Field cache(ResolverQuery query, Field field) throws ReflectiveOperationException {
        AccessUtil.setAccessible(field);
        this.fieldCache.put(query, field);
        return field;
    }
}

