/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.reflection.resolver;

import info.cho.passwords.fairy.bukkit.reflection.resolver.MemberResolver;
import info.cho.passwords.fairy.bukkit.reflection.resolver.ResolverQuery;
import info.cho.passwords.fairy.bukkit.reflection.wrapper.FieldWrapper;
import info.cho.passwords.fairy.util.AccessUtil;
import info.cho.passwords.fairy.util.exceptionally.ThrowingSupplier;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class FieldResolver
extends MemberResolver<Field> {
    public FieldResolver(Class<?> clazz) {
        super(clazz);
    }

    public FieldResolver(String className) throws ClassNotFoundException {
        super(className);
    }

    @Override
    public Field resolveIndex(int index) throws IndexOutOfBoundsException, ReflectiveOperationException {
        return AccessUtil.setAccessible(this.clazz.getDeclaredFields()[index]);
    }

    @Override
    public Field resolveIndexSilent(int index) {
        try {
            return this.resolveIndex(index);
        }
        catch (IndexOutOfBoundsException | ReflectiveOperationException exception) {
            return null;
        }
    }

    @Override
    public FieldWrapper resolveIndexWrapper(int index) {
        return new FieldWrapper(this.resolveIndexSilent(index));
    }

    public FieldWrapper resolveWrapper(String ... names) {
        return ThrowingSupplier.sneaky(() -> new FieldWrapper(this.resolve(names))).get();
    }

    public Field resolveSilent(String ... names) {
        try {
            return this.resolve(names);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Field resolve(String ... names) throws NoSuchFieldException {
        ResolverQuery.Builder builder = ResolverQuery.builder();
        for (String name : names) {
            builder.with(name);
        }
        try {
            return (Field)super.resolve(builder.build());
        }
        catch (ReflectiveOperationException e) {
            throw (NoSuchFieldException)e;
        }
    }

    @Override
    public Field resolveSilent(ResolverQuery ... queries) {
        try {
            return this.resolve(queries);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Field resolve(ResolverQuery ... queries) throws NoSuchFieldException {
        try {
            return (Field)super.resolve(queries);
        }
        catch (ReflectiveOperationException e) {
            throw (NoSuchFieldException)e;
        }
    }

    public <T> FieldWrapper<T> resolve(Class<T> type, int index) {
        try {
            return new FieldWrapper(this.resolve(new ResolverQuery(type, index)));
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public <T> FieldWrapper<T> resolveSilent(Class<T> type, int index) {
        return new FieldWrapper(this.resolveSilent(new ResolverQuery(type, index)));
    }

    public <T> List<FieldWrapper<T>> resolveList(Class<T> type) {
        ArrayList<FieldWrapper<T>> fieldList = new ArrayList<FieldWrapper<T>>();
        try {
            int index = 0;
            while (true) {
                FieldWrapper<T> field;
                try {
                    field = this.resolve(type, index++);
                }
                catch (IllegalArgumentException e) {
                    break;
                }
                fieldList.add(field);
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        return fieldList;
    }

    public <T> FieldWrapper<T> resolveWithGenericType(Class<T> fieldType, Class<?> ... genericType) {
        try {
            return new FieldWrapper(this.resolve(new ResolverQuery(fieldType, -1, genericType)));
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    @Override
    protected Field resolveObject(ResolverQuery query) throws ReflectiveOperationException {
        return this.accessorCache.resolveField(query);
    }

    public Field resolveByFirstType(Class<?> type) throws ReflectiveOperationException {
        return this.resolve(new ResolverQuery(type, 0));
    }

    public FieldWrapper resolveByFirstTypeWrapper(Class<?> type) throws ReflectiveOperationException {
        return new FieldWrapper(this.resolveByFirstType(type));
    }

    public FieldWrapper resolveByFirstTypeDynamic(Class<?> type) throws ReflectiveOperationException {
        Field field = this.resolve(new ResolverQuery(type, -1).withModifierOptions(ResolverQuery.ModifierOptions.builder().onlyDynamic(true).build()));
        if (field != null) {
            return new FieldWrapper(field);
        }
        throw new NoSuchFieldException("Could not resolve field of type '" + type.toString() + "' in class " + this.clazz);
    }

    public Field resolveByFirstTypeSilent(Class<?> type) {
        try {
            return this.resolveByFirstType(type);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Field resolveByLastType(Class<?> type) throws ReflectiveOperationException {
        Field field = this.resolve(new ResolverQuery(type, -2));
        if (field == null) {
            throw new NoSuchFieldException("Could not resolve field of type '" + type.toString() + "' in class " + this.clazz);
        }
        return field;
    }

    public FieldWrapper resolveByLastTypeWrapper(Class<?> type) throws ReflectiveOperationException {
        return new FieldWrapper(this.resolveByLastType(type));
    }

    public Field resolveByLastTypeSilent(Class<?> type) {
        try {
            return this.resolveByLastType(type);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    protected NoSuchFieldException notFoundException(String joinedNames) {
        return new NoSuchFieldException("Could not resolve field for " + joinedNames + " in class " + this.clazz);
    }
}

