/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.scheduler.bukkit;

import info.cho.passwords.fairy.bukkit.scheduler.bukkit.BukkitAbstractScheduler;
import info.cho.passwords.fairy.bukkit.scheduler.bukkit.BukkitRepeatedScheduledTask;
import info.cho.passwords.fairy.scheduler.ScheduledTask;
import info.cho.passwords.fairy.scheduler.repeat.RepeatPredicate;
import info.cho.passwords.fairy.scheduler.response.TaskResponse;
import java.util.concurrent.Callable;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class BukkitAsyncScheduler
extends BukkitAbstractScheduler {
    private final Plugin bukkitPlugin;

    @Override
    public boolean isCurrentThread() {
        return Thread.currentThread().getName().contains("Craft Scheduler Thread");
    }

    @Override
    public <R> ScheduledTask<R> schedule(Callable<R> callable) {
        return this.doSchedule(callable, task -> Bukkit.getScheduler().runTaskAsynchronously(this.bukkitPlugin, task));
    }

    @Override
    public <R> ScheduledTask<R> schedule(Callable<R> callable, long delayTicks) {
        return this.doSchedule(callable, task -> Bukkit.getScheduler().runTaskLaterAsynchronously(this.bukkitPlugin, task, delayTicks));
    }

    @Override
    public <R> ScheduledTask<R> scheduleAtFixedRate(Callable<TaskResponse<R>> callback, long delayTicks, long intervalTicks, RepeatPredicate<R> predicate) {
        BukkitRepeatedScheduledTask<R> task = new BukkitRepeatedScheduledTask<R>(callback, predicate);
        task.setBukkitTask(Bukkit.getScheduler().runTaskTimerAsynchronously(this.bukkitPlugin, task, delayTicks, intervalTicks));
        return task;
    }

    public BukkitAsyncScheduler(Plugin bukkitPlugin) {
        this.bukkitPlugin = bukkitPlugin;
    }
}

