/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.scheduler.bukkit;

import info.cho.passwords.fairy.log.Log;
import info.cho.passwords.fairy.scheduler.ScheduledTask;
import info.cho.passwords.fairy.scheduler.repeat.RepeatPredicate;
import info.cho.passwords.fairy.scheduler.response.TaskResponse;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import org.bukkit.scheduler.BukkitTask;

public class BukkitRepeatedScheduledTask<R>
implements ScheduledTask<R>,
Runnable {
    private final CompletableFuture<R> future = new CompletableFuture();
    private final Callable<TaskResponse<R>> callable;
    private final RepeatPredicate<R> predicate;
    private BukkitTask bukkitTask;

    @Override
    public CompletableFuture<R> getFuture() {
        return this.future;
    }

    @Override
    public void run() {
        try {
            TaskResponse<R> response = this.callable.call();
            switch (response.getState()) {
                case SUCCESS: {
                    this.future.complete(response.getResult());
                    this.bukkitTask.cancel();
                    break;
                }
                case FAILURE: {
                    Throwable throwable = response.getThrowable();
                    String errorMessage = response.getErrorMessage();
                    if (throwable != null) {
                        this.future.completeExceptionally(throwable);
                    } else {
                        this.future.completeExceptionally(new IllegalStateException(errorMessage));
                    }
                    this.bukkitTask.cancel();
                    break;
                }
                case CONTINUE: {
                    if (!this.predicate.shouldContinue(this)) {
                        this.bukkitTask.cancel();
                        this.future.complete(this.predicate.getDefaultValue());
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + (Object)((Object)response.getState()));
                }
            }
        }
        catch (Exception e) {
            Log.error("An error occurred while executing a scheduled task", e, new Object[0]);
            this.future.completeExceptionally(e);
            this.bukkitTask.cancel();
        }
    }

    @Override
    public void cancel() {
        this.future.cancel(false);
        this.bukkitTask.cancel();
    }

    public BukkitRepeatedScheduledTask(Callable<TaskResponse<R>> callable, RepeatPredicate<R> predicate) {
        this.callable = callable;
        this.predicate = predicate;
    }

    public void setBukkitTask(BukkitTask bukkitTask) {
        this.bukkitTask = bukkitTask;
    }
}

