/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.timer;

import com.google.common.collect.ImmutableSet;
import info.cho.passwords.fairy.bukkit.timer.TimerService;
import info.cho.passwords.fairy.bukkit.timer.event.TimerClearEvent;
import info.cho.passwords.fairy.bukkit.timer.event.TimerElapsedEvent;
import info.cho.passwords.fairy.bukkit.timer.event.TimerExtendEvent;
import info.cho.passwords.fairy.bukkit.timer.event.TimerPauseEvent;
import info.cho.passwords.fairy.bukkit.timer.event.TimerStartEvent;
import info.cho.passwords.fairy.bukkit.timer.event.TimerUnpauseEvent;
import info.cho.passwords.fairy.container.Autowired;
import info.cho.passwords.fairy.libs.kyori.adventure.text.Component;
import info.cho.passwords.fairy.libs.kyori.adventure.text.format.NamedTextColor;
import info.cho.passwords.fairy.libs.kyori.adventure.text.format.TextColor;
import info.cho.passwords.fairy.mc.MCPlayer;
import info.cho.passwords.fairy.util.terminable.Terminable;
import info.cho.passwords.fairy.util.terminable.TerminableConsumer;
import info.cho.passwords.fairy.util.terminable.composite.CompositeTerminable;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public abstract class Timer
implements Terminable,
TerminableConsumer {
    @Autowired
    protected static TimerService TIMER_SERVICE;
    protected static final Set<Integer> COUNTDOWNS;
    private final long startTime;
    private long pauseTime;
    private long duration;
    private long elapsedTime;
    private int currentAnnounceSeconds;
    private final CompositeTerminable compositeTerminable = CompositeTerminable.create();
    private boolean closed;

    public Timer(long startTime, long duration) {
        this.startTime = startTime;
        this.duration = duration;
        this.pauseTime = -1L;
        this.elapsedTime = this.startTime + this.duration;
    }

    public Timer(long duration) {
        this(System.currentTimeMillis(), duration);
    }

    public final boolean shouldAnnounce(int seconds) {
        if (this.currentAnnounceSeconds == seconds) {
            return false;
        }
        this.currentAnnounceSeconds = seconds;
        return COUNTDOWNS.contains(seconds) && this.isAnnouncing(seconds);
    }

    protected boolean isAnnouncing(int time) {
        return false;
    }

    public boolean isElapsed() {
        return System.currentTimeMillis() > this.elapsedTime;
    }

    public long getTimeMillisRemaining() {
        return this.elapsedTime - System.currentTimeMillis();
    }

    public int getSecondsRemaining() {
        return (int)TimeUnit.MILLISECONDS.toSeconds(this.getTimeMillisRemaining());
    }

    public void restart(long startTime) {
        long diff = startTime - this.startTime;
        this.extend(diff);
    }

    public void extend(long millis) {
        this.extend(millis, TimerExtendEvent.Reason.PLUGIN);
    }

    public void extend(long millis, TimerExtendEvent.Reason reason) {
        TimerExtendEvent event = new TimerExtendEvent(this, this.duration, this.duration + millis, millis, reason);
        event.call();
        if (event.isCancelled()) {
            return;
        }
        millis = event.getExtended();
        this.duration += millis;
        this.elapsedTime = this.startTime + this.duration;
    }

    public void setDuration(long duration) {
        this.setDuration(duration, TimerExtendEvent.Reason.PLUGIN);
    }

    public void setDuration(long duration, TimerExtendEvent.Reason reason) {
        TimerExtendEvent event = new TimerExtendEvent(this, this.duration, duration, duration - this.duration, reason);
        event.call();
        if (event.isCancelled()) {
            return;
        }
        this.duration = duration = this.duration + event.getExtended();
        this.elapsedTime = this.startTime + this.duration;
    }

    public Component getAnnounceMessage(Player player, int seconds) {
        return Component.text("Time Remaining: ", (TextColor)NamedTextColor.YELLOW).append(Component.text(seconds));
    }

    public void sendMessage(Player player, Component message, int seconds) {
        MCPlayer.from(player).sendMessage(message);
    }

    public final void tick() {
        Collection<? extends Player> players;
        int seconds = this.getSecondsRemaining();
        if (this.shouldAnnounce(seconds) && (players = this.getReceivers()) != null) {
            for (Player player : players) {
                Component component = this.getAnnounceMessage(player, seconds);
                this.sendMessage(player, component, seconds);
            }
        }
        this.onTick();
    }

    protected void onTick() {
    }

    public abstract Collection<? extends Player> getReceivers();

    @Override
    public void close() {
        this.clear();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    @NotNull
    public <T extends Terminable> T bind(@NotNull T terminable) {
        return this.compositeTerminable.bind(terminable);
    }

    public final boolean clear() {
        return this.clear(true, TimerClearEvent.Reason.PLUGIN);
    }

    protected final boolean clear(boolean removeFromHandler, TimerClearEvent.Reason reason) {
        return new TimerClearEvent(this, reason).supplyCancelled(cancel -> {
            if (cancel.booleanValue()) {
                return false;
            }
            if (!this.shouldClear()) {
                return false;
            }
            if (removeFromHandler) {
                TIMER_SERVICE.clear(this);
            }
            this.onPreClear();
            this.closed = true;
            this.onClear();
            this.compositeTerminable.closeAndReportException();
            return true;
        });
    }

    protected abstract void onPreClear();

    protected boolean shouldClear() {
        return true;
    }

    protected void onClear() {
    }

    public final boolean unpause() {
        if (this.pauseTime == -1L) {
            return false;
        }
        return new TimerUnpauseEvent(this).supplyCancelled(cancel -> {
            if (cancel.booleanValue()) {
                return false;
            }
            if (!this.shouldUnpause()) {
                return false;
            }
            long toExtend = System.currentTimeMillis() - this.pauseTime;
            this.extend(toExtend, TimerExtendEvent.Reason.UNPAUSE);
            this.pauseTime = -1L;
            this.onUnpause();
            return true;
        });
    }

    protected boolean shouldUnpause() {
        return true;
    }

    protected void onUnpause() {
    }

    public final boolean pause() {
        if (this.pauseTime != -1L) {
            return false;
        }
        return new TimerPauseEvent(this).supplyCancelled(cancel -> {
            if (cancel.booleanValue()) {
                return false;
            }
            if (!this.shouldPause()) {
                return false;
            }
            this.pauseTime = System.currentTimeMillis();
            this.onPause();
            return true;
        });
    }

    public final boolean isPaused() {
        return this.pauseTime != -1L;
    }

    protected boolean shouldPause() {
        return true;
    }

    protected void onPause() {
    }

    public final boolean start() {
        return new TimerStartEvent(this).supplyCancelled(cancel -> {
            if (cancel.booleanValue()) {
                return false;
            }
            if (!this.shouldStart()) {
                return false;
            }
            this.onStart();
            this.onPostStart();
            return true;
        });
    }

    protected abstract void onPostStart();

    protected boolean shouldStart() {
        return true;
    }

    protected void onStart() {
    }

    public final boolean elapsed() {
        return new TimerElapsedEvent(this).supplyCancelled(cancel -> {
            if (cancel.booleanValue()) {
                return false;
            }
            if (!this.shouldElapsed()) {
                return false;
            }
            this.onElapsed();
            return true;
        });
    }

    protected boolean shouldElapsed() {
        return true;
    }

    protected void onElapsed() {
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getPauseTime() {
        return this.pauseTime;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public int getCurrentAnnounceSeconds() {
        return this.currentAnnounceSeconds;
    }

    public CompositeTerminable getCompositeTerminable() {
        return this.compositeTerminable;
    }

    static {
        COUNTDOWNS = ImmutableSet.of((Object)3200, (Object)1600, (Object)1200, (Object)600, (Object)300, (Object)180, (Object[])new Integer[]{120, 60, 30, 15, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0});
    }
}

