/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.timer;

import com.google.common.collect.Sets;
import info.cho.passwords.fairy.bukkit.FairyBukkitPlatform;
import info.cho.passwords.fairy.bukkit.listener.events.Events;
import info.cho.passwords.fairy.bukkit.metadata.Metadata;
import info.cho.passwords.fairy.bukkit.timer.Timer;
import info.cho.passwords.fairy.bukkit.timer.TimerList;
import info.cho.passwords.fairy.bukkit.timer.event.TimerClearEvent;
import info.cho.passwords.fairy.bukkit.timer.impl.PlayerTimer;
import info.cho.passwords.fairy.container.InjectableComponent;
import info.cho.passwords.fairy.container.PostInitialize;
import info.cho.passwords.fairy.log.Log;
import info.cho.passwords.fairy.mc.scheduler.MCSchedulerProvider;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

@InjectableComponent
public class TimerService {
    private final MCSchedulerProvider mcSchedulerProvider;
    private Set<Timer> timers;
    private ReentrantLock lock;

    @PostInitialize
    public void onPostInitialize() {
        this.lock = new ReentrantLock();
        this.timers = Sets.newConcurrentHashSet();
        this.startScheduler();
        Events.subscribe(PlayerQuitEvent.class).listen(event -> Metadata.provideForPlayer(event.getPlayer()).ifPresent(PlayerTimer.TIMER_METADATA_KEY, TimerList::clear)).build((Plugin)FairyBukkitPlatform.PLUGIN);
    }

    protected void add(Timer timer) {
        this.lock.lock();
        this.timers.add(timer);
        this.lock.unlock();
    }

    protected void clear(Timer timer) {
        this.lock.lock();
        this.timers.remove(timer);
        this.lock.unlock();
    }

    public void clearByTimerClass(Class<? extends Timer> timerClass) {
        this.lock.lock();
        this.timers.removeIf(timer -> timerClass.isInstance(timer) && timer.clear());
        this.lock.unlock();
    }

    public void startScheduler() {
        this.mcSchedulerProvider.getGlobalScheduler().scheduleAtFixedRate(() -> {
            this.lock.lock();
            Iterator<Timer> iterator = this.timers.iterator();
            while (iterator.hasNext()) {
                Timer timer = iterator.next();
                try {
                    if (timer.isPaused()) continue;
                    timer.tick();
                    if (!timer.isElapsed() || !timer.elapsed() || !timer.clear(false, TimerClearEvent.Reason.ELAPSED)) continue;
                    iterator.remove();
                }
                catch (Exception e) {
                    Log.error("Error occurred while ticking timer " + timer.getClass().getSimpleName() + "!", e, new Object[0]);
                    timer.clear();
                }
            }
            this.lock.unlock();
        }, 2L, 2L);
    }

    public boolean isTimerRunning(Class<? extends Timer> timerClass) {
        return this.getTimer(timerClass) != null;
    }

    public <T extends Timer> T getTimer(Class<T> timerClass) {
        Timer ret;
        this.lock.lock();
        try {
            ret = (Timer)timerClass.cast(this.timers.stream().filter(timerClass::isInstance).findFirst().orElse(null));
        }
        finally {
            this.lock.unlock();
        }
        return (T)ret;
    }

    public TimerService(MCSchedulerProvider mcSchedulerProvider) {
        this.mcSchedulerProvider = mcSchedulerProvider;
    }
}

