/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.timings;

import info.cho.passwords.fairy.Debug;
import info.cho.passwords.fairy.bukkit.timings.MCTiming;
import info.cho.passwords.fairy.bukkit.timings.TimingType;
import info.cho.passwords.fairy.container.InjectableComponent;
import info.cho.passwords.fairy.container.PreInitialize;
import info.cho.passwords.fairy.mc.MCServer;
import info.cho.passwords.fairy.mc.version.MCVersion;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.plugin.Plugin;

@InjectableComponent
public class TimingService {
    private final Map<String, MCTiming> timingCache = new HashMap<String, MCTiming>(0);
    private final MCServer mcServer;
    private TimingType timingType;

    @PreInitialize
    public void onPreInitialize() {
        if (this.timingType == null) {
            if (Debug.UNIT_TEST) {
                this.timingType = TimingType.UNIT_TESTING;
                return;
            }
            try {
                Class<?> clazz = Class.forName("co.aikar.timings.Timing");
                Method startTiming = clazz.getMethod("startTiming", new Class[0]);
                this.timingType = this.mcServer.getVersion().isHigherOrEqual(MCVersion.of(19, 4)) ? TimingType.EMPTY : (startTiming.getReturnType() != clazz ? TimingType.MINECRAFT_18 : TimingType.MINECRAFT);
            }
            catch (ClassNotFoundException | NoSuchMethodException ignored1) {
                try {
                    Class.forName("org.spigotmc.CustomTimingsHandler");
                    this.timingType = TimingType.SPIGOT;
                }
                catch (ClassNotFoundException ignored2) {
                    this.timingType = TimingType.EMPTY;
                }
            }
        }
    }

    public MCTiming ofStart(Plugin plugin, String name) {
        return this.ofStart(plugin, name, null);
    }

    public MCTiming ofStart(Plugin plugin, String name, MCTiming parent) {
        return this.of(plugin, name, parent).startTiming();
    }

    public MCTiming of(Plugin plugin, String name) {
        return this.of(plugin, name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MCTiming of(Plugin plugin, String name, MCTiming parent) {
        if (this.timingType.useCache()) {
            MCTiming timing;
            Map<String, MCTiming> map = this.timingCache;
            synchronized (map) {
                String lowerKey = name.toLowerCase();
                timing = this.timingCache.get(lowerKey);
                if (timing == null) {
                    timing = this.timingType.newTiming(plugin, name, parent);
                    this.timingCache.put(lowerKey, timing);
                }
            }
            return timing;
        }
        return this.timingType.newTiming(plugin, name, parent);
    }

    public TimingService(MCServer mcServer) {
        this.mcServer = mcServer;
    }
}

