/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.util;

import info.cho.passwords.fairy.Fairy;
import java.util.Objects;
import java.util.StringJoiner;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.util.NumberConversions;

@Deprecated
public class CustomLocation {
    private String world = "world";
    private double x = 0.0;
    private double y = 0.0;
    private double z = 0.0;
    private float yaw = 0.0f;
    private float pitch = 0.0f;

    public CustomLocation(double x, double y, double z) {
        this(x, y, z, 0.0f, 0.0f);
    }

    public CustomLocation(String world, double x, double y, double z) {
        this(world, x, y, z, 0.0f, 0.0f);
    }

    public CustomLocation(double x, double y, double z, float yaw, float pitch) {
        this("world", x, y, z, yaw, pitch);
    }

    public static CustomLocation fromBukkitLocation(Location location) {
        return new CustomLocation(location.getWorld().getName(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    public static CustomLocation stringToLocation(String string) {
        String[] split = string.split(", ");
        double x = Double.parseDouble(split[0]);
        double y = Double.parseDouble(split[1]);
        double z = Double.parseDouble(split[2]);
        CustomLocation customLocation = new CustomLocation(x, y, z);
        if (split.length == 4) {
            customLocation.setWorld(split[3]);
        } else if (split.length >= 5) {
            customLocation.setYaw(Float.parseFloat(split[3]));
            customLocation.setPitch(Float.parseFloat(split[4]));
            if (split.length >= 6) {
                customLocation.setWorld(split[5]);
            }
        }
        return customLocation;
    }

    public static String locationToString(CustomLocation loc) {
        StringJoiner joiner = new StringJoiner(", ");
        joiner.add(Double.toString(loc.getX()));
        joiner.add(Double.toString(loc.getY()));
        joiner.add(Double.toString(loc.getZ()));
        if (loc.getYaw() == 0.0f && loc.getPitch() == 0.0f) {
            if (loc.getWorld().equals("world")) {
                return joiner.toString();
            }
            joiner.add(loc.getWorld());
            return joiner.toString();
        }
        joiner.add(Float.toString(loc.getYaw()));
        joiner.add(Float.toString(loc.getPitch()));
        if (loc.getWorld().equals("world")) {
            return joiner.toString();
        }
        joiner.add(loc.getWorld());
        return joiner.toString();
    }

    public Location toBukkitLocation() {
        return new Location(this.toBukkitWorld(), this.x, this.y, this.z, this.yaw, this.pitch);
    }

    public double getGroundDistanceTo(CustomLocation location) {
        return Math.sqrt(Math.pow(this.x - location.x, 2.0) + Math.pow(this.z - location.z, 2.0));
    }

    public double getDistanceTo(CustomLocation location) {
        return Math.sqrt(Math.pow(this.x - location.x, 2.0) + Math.pow(this.y - location.y, 2.0) + Math.pow(this.z - location.z, 2.0));
    }

    public World toBukkitWorld() {
        if (this.world == null) {
            return (World)Bukkit.getServer().getWorlds().get(0);
        }
        return Bukkit.getServer().getWorld(this.world);
    }

    public CustomLocation add(CustomLocation location) {
        this.x += location.x;
        this.y += location.y;
        this.z += location.z;
        return this;
    }

    public CustomLocation subtract(CustomLocation location) {
        this.x -= location.x;
        this.y -= location.y;
        this.z -= location.z;
        return this;
    }

    public CustomLocation multiply(CustomLocation location) {
        this.x *= location.x;
        this.y *= location.y;
        this.z *= location.z;
        return this;
    }

    public CustomLocation divide(CustomLocation location) {
        this.x /= location.x;
        this.y /= location.y;
        this.z /= location.z;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomLocation location = (CustomLocation)o;
        if (Double.compare(location.x, this.x) != 0) {
            return false;
        }
        if (Double.compare(location.y, this.y) != 0) {
            return false;
        }
        if (Double.compare(location.z, this.z) != 0) {
            return false;
        }
        if (Float.compare(location.yaw, this.yaw) != 0) {
            return false;
        }
        if (Float.compare(location.pitch, this.pitch) != 0) {
            return false;
        }
        return Objects.equals(this.world, location.world);
    }

    public int hashCode() {
        int result = this.world != null ? this.world.hashCode() : 0;
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.z);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.yaw != 0.0f ? Float.floatToIntBits(this.yaw) : 0);
        result = 31 * result + (this.pitch != 0.0f ? Float.floatToIntBits(this.pitch) : 0);
        return result;
    }

    public String toString() {
        return CustomLocation.locationToString(this);
    }

    public static int locToBlock(double loc) {
        return NumberConversions.floor((double)loc);
    }

    public int getBlockX() {
        return CustomLocation.locToBlock(this.x);
    }

    public int getBlockY() {
        return CustomLocation.locToBlock(this.y);
    }

    public int getBlockZ() {
        return CustomLocation.locToBlock(this.z);
    }

    public void teleport(Player player, double range) {
        this.teleport(player, range, true);
    }

    public void teleport(Player player, double range, boolean safe) {
        double rand = -range + range * 2.0 * Fairy.random().nextDouble();
        player.teleport(this.toBukkitLocation().add(rand, safe ? 1.5 : 0.0, rand));
    }

    public String getWorld() {
        return this.world;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setWorld(String world) {
        this.world = world;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public CustomLocation(String world, double x, double y, double z, float yaw, float pitch) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public CustomLocation() {
    }
}

