/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.util.items;

import info.cho.passwords.fairy.bukkit.util.items.FairyItemRegistry;
import info.cho.passwords.fairy.bukkit.util.items.ItemBuilder;
import info.cho.passwords.fairy.bukkit.util.items.behaviour.ItemBehaviour;
import info.cho.passwords.fairy.bukkit.util.items.impl.FairyItemImpl;
import info.cho.passwords.fairy.container.Autowired;
import info.cho.passwords.fairy.data.MetaKey;
import info.cho.passwords.fairy.data.MetaStorage;
import info.cho.passwords.fairy.mc.MCPlayer;
import info.cho.passwords.fairy.util.terminable.Terminable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface FairyItem
extends Terminable {
    public static Builder builder(@NotNull String name) {
        return new Builder(name);
    }

    @NotNull
    public String getName();

    @NotNull
    public MetaStorage getMetaStorage();

    @NotNull
    public Iterable<ItemBehaviour> getBehaviours();

    @NotNull
    public ItemBuilder provide(@NotNull MCPlayer var1);

    @NotNull
    default public ItemBuilder provide(@NotNull Player player) {
        return this.provide(MCPlayer.from(player));
    }

    @NotNull
    default public ItemStack provideItemStack(@NotNull MCPlayer mcPlayer) {
        return this.provide(mcPlayer).build();
    }

    @NotNull
    default public ItemStack provideItemStack(@NotNull Player player) {
        return this.provideItemStack(MCPlayer.from(player));
    }

    public boolean isSimilar(@NotNull ItemStack var1);

    @ApiStatus.Internal
    public void init();

    @Override
    @ApiStatus.Internal
    public void close() throws Exception;

    @Override
    @ApiStatus.Internal
    @Nullable
    default public Exception closeSilently() {
        return Terminable.super.closeSilently();
    }

    @Override
    @ApiStatus.Internal
    default public void closeAndReportException() {
        Terminable.super.closeAndReportException();
    }

    public static class Builder {
        @Autowired
        private static FairyItemRegistry REGISTRY;
        private final String name;
        private Function<MCPlayer, ItemBuilder> itemProvider;
        private final MetaStorage metaStorage = MetaStorage.create();
        private final List<ItemBehaviour> behaviours = new ArrayList<ItemBehaviour>();

        private Builder(@NotNull String name) {
            this.name = name;
        }

        public Builder behaviour(@NotNull ItemBehaviour behaviour) {
            this.behaviours.add(behaviour);
            return this;
        }

        public Builder item(@NotNull ItemStack itemStack) {
            return this.item((MCPlayer mcPlayer) -> ItemBuilder.of(itemStack));
        }

        public Builder item(@NotNull ItemBuilder itemBuilder) {
            return this.item((MCPlayer mcPlayer) -> itemBuilder);
        }

        public Builder item(@NotNull Function<MCPlayer, ItemBuilder> itemProvider) {
            this.itemProvider = itemProvider;
            return this;
        }

        public Builder transformMeta(@NotNull Consumer<MetaStorage> consumer) {
            consumer.accept(this.metaStorage);
            return this;
        }

        public <T> Builder put(@NotNull MetaKey<T> metadataKey, @NotNull T value) {
            this.metaStorage.put(metadataKey, value);
            return this;
        }

        @Deprecated
        public FairyItem build() {
            FairyItemImpl fairyItem = new FairyItemImpl(REGISTRY, this.name, this.metaStorage, this.behaviours, this.itemProvider);
            REGISTRY.register(fairyItem);
            return fairyItem;
        }

        @Deprecated
        public FairyItem create() {
            return new FairyItemImpl(REGISTRY, this.name, this.metaStorage, this.behaviours, this.itemProvider);
        }

        public FairyItem create(FairyItemRegistry itemRegistry) {
            FairyItemImpl fairyItem = new FairyItemImpl(itemRegistry, this.name, this.metaStorage, this.behaviours, this.itemProvider);
            itemRegistry.register(fairyItem);
            return fairyItem;
        }
    }
}

