/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.util.items.behaviour;

import info.cho.passwords.fairy.bukkit.listener.ListenerRegistry;
import info.cho.passwords.fairy.bukkit.util.items.FairyItem;
import info.cho.passwords.fairy.bukkit.util.items.FairyItemRegistry;
import info.cho.passwords.fairy.bukkit.util.items.behaviour.ItemBehaviourListener;
import info.cho.passwords.fairy.data.MetaKey;
import info.cho.passwords.fairy.data.MetaStorage;
import info.cho.passwords.fairy.libs.xseries.XSound;
import info.cho.passwords.fairy.mc.data.MCMetadata;
import info.cho.passwords.fairy.mc.registry.player.MCPlayerRegistry;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;

public class ItemBehaviourBlockMarker
extends ItemBehaviourListener {
    private static final MetaKey<String> METADATA = MetaKey.create("fairy:block-marker", String.class);
    private final FairyItemRegistry fairyItemRegistry;
    private final MCPlayerRegistry mcPlayerRegistry;

    public ItemBehaviourBlockMarker(ListenerRegistry listenerRegistry, FairyItemRegistry fairyItemRegistry, MCPlayerRegistry mcPlayerRegistry) {
        super(listenerRegistry);
        this.fairyItemRegistry = fairyItemRegistry;
        this.mcPlayerRegistry = mcPlayerRegistry;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        ItemStack itemInHand = event.getItemInHand();
        if (!this.matches(player, itemInHand)) {
            return;
        }
        FairyItem item = this.fairyItemRegistry.get(itemInHand);
        if (item != this.item) {
            return;
        }
        MCMetadata.provide(block).put(METADATA, this.item.getName());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        MetaStorage metaStorage = MCMetadata.provide(block);
        String itemKey = metaStorage.getOrNull(METADATA);
        if (itemKey == null || !itemKey.equals(this.item.getName())) {
            return;
        }
        metaStorage.remove(METADATA);
        FairyItem item = this.fairyItemRegistry.get(itemKey);
        if (item == null) {
            return;
        }
        this.addHandHeldItemDurability(player, 1);
        event.setCancelled(true);
        block.setType(Material.AIR);
        ItemStack itemStack = item.provide(this.mcPlayerRegistry.findPlayerByUuid(player.getUniqueId())).amount(1).build();
        player.getWorld().dropItemNaturally(block.getLocation(), itemStack);
    }

    private void addHandHeldItemDurability(Player player, int amount) {
        ItemStack itemStack = player.getItemInHand();
        if (itemStack.getType().getMaxDurability() > 1) {
            itemStack.setDurability((short)(itemStack.getDurability() + amount));
            if (itemStack.getDurability() > itemStack.getType().getMaxDurability()) {
                player.setItemInHand(null);
                player.updateInventory();
                XSound.ENTITY_ITEM_BREAK.play((Entity)player);
            }
        }
    }

    @Override
    public boolean shouldFilterItemKey() {
        return false;
    }
}

