/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.bukkit.visibility;

import info.cho.passwords.fairy.bukkit.events.player.PlayerPostJoinEvent;
import info.cho.passwords.fairy.bukkit.listener.RegisterAsListener;
import info.cho.passwords.fairy.bukkit.visibility.VisibilityService;
import info.cho.passwords.fairy.container.Autowired;
import info.cho.passwords.fairy.container.InjectableComponent;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChatTabCompleteEvent;

@InjectableComponent
@RegisterAsListener
public class VisibilityListener
implements Listener {
    @Autowired
    private VisibilityService visibilityService;

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerPostJoinEvent event) {
        this.visibilityService.update(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onTabComplete(PlayerChatTabCompleteEvent event) {
        String token = event.getLastToken();
        Collection completions = event.getTabCompletions();
        completions.clear();
        for (Player target : Bukkit.getOnlinePlayers()) {
            if (!this.visibilityService.treatAsOnline(target, event.getPlayer()) || !target.getName().toLowerCase().startsWith(token.toLowerCase())) continue;
            completions.add(target.getName());
        }
    }
}

