/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.command.parameter.impl;

import info.cho.passwords.fairy.command.CommandContext;
import info.cho.passwords.fairy.command.parameter.ArgTransformer;
import info.cho.passwords.fairy.container.object.Obj;

@Obj
class FloatArgTransformer
implements ArgTransformer<Float> {
    FloatArgTransformer() {
    }

    @Override
    public Class[] type() {
        return new Class[]{Float.class, Float.TYPE};
    }

    @Override
    public Float transform(CommandContext event, String source) {
        if (source.toLowerCase().contains("e")) {
            return (Float)this.fail(source + " is not a valid number.");
        }
        try {
            float parsed = Float.parseFloat(source);
            if (Float.isNaN(parsed) || !Float.isFinite(parsed)) {
                return (Float)this.fail(source + " is not a valid number.");
            }
            return Float.valueOf(parsed);
        }
        catch (NumberFormatException exception) {
            return (Float)this.fail(source + " is not a valid number.");
        }
    }
}

