/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.command.parameter.impl;

import info.cho.passwords.fairy.command.CommandContext;
import info.cho.passwords.fairy.command.parameter.ArgTransformer;
import info.cho.passwords.fairy.container.object.Obj;

@Obj
public class LongArgTransformer
implements ArgTransformer<Long> {
    @Override
    public Class[] type() {
        return new Class[]{Long.class, Long.TYPE};
    }

    @Override
    public Long transform(CommandContext event, String source) {
        if (source.toLowerCase().contains("e")) {
            return (Long)this.fail(source + " is not a valid number.");
        }
        try {
            long parsed = Long.parseLong(source);
            if (Double.isNaN(parsed) || !Double.isFinite(parsed)) {
                return (Long)this.fail(source + " is not a valid number.");
            }
            return parsed;
        }
        catch (NumberFormatException exception) {
            return (Long)this.fail(source + " is not a valid number.");
        }
    }
}

