/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.config;

import info.cho.passwords.fairy.config.annotation.Comment;
import info.cho.passwords.fairy.config.annotation.NestedComment;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Comments {
    private final List<String> classComments;
    private final Map<String, List<String>> fieldComments;

    private Comments(List<String> classComments, Map<String, List<String>> fieldComments) {
        this.classComments = classComments;
        this.fieldComments = fieldComments;
    }

    static Comments ofClass(Class<?> cls) {
        List<String> classComments = Comments.getComments(cls);
        HashMap<String, List<String>> fieldComments = new HashMap<String, List<String>>();
        Arrays.stream(cls.getDeclaredFields()).filter(field -> Comments.isCommented(field) || Comments.isNestedCommented(field)).forEach(field -> {
            if (Comments.isCommented(field)) {
                fieldComments.put(field.getName(), Comments.getComments(field));
            }
            if (Comments.isNestedCommented(field)) {
                Comments.putNestedComments(field, fieldComments, "");
            }
        });
        return new Comments(classComments, fieldComments);
    }

    private static void putNestedComments(Field field, Map<String, List<String>> map, String path) {
        Class<?> type = field.getType();
        if (path.equals("") || path.isEmpty()) {
            path = field.getName() + ".";
        }
        if (type.getDeclaredFields().length > 0) {
            String finalMain = path;
            Arrays.stream(type.getDeclaredFields()).filter(f -> Comments.isCommented(f) || Comments.isNestedCommented(f)).forEach(f -> {
                if (Comments.isCommented(f)) {
                    map.put(finalMain + f.getName(), Comments.getComments(f));
                }
                if (Comments.isNestedCommented(f)) {
                    Comments.putNestedComments(f, map, finalMain + f.getName() + ".");
                }
            });
        }
    }

    private static boolean isCommented(AnnotatedElement element) {
        return element.isAnnotationPresent(Comment.class);
    }

    private static boolean isNestedCommented(AnnotatedElement element) {
        return element.isAnnotationPresent(NestedComment.class);
    }

    private static List<String> getComments(AnnotatedElement element) {
        Comment comment = element.getAnnotation(Comment.class);
        return comment != null ? Arrays.asList(comment.value()) : Collections.emptyList();
    }

    public boolean hasClassComments() {
        return !this.classComments.isEmpty();
    }

    public boolean hasFieldComments() {
        return !this.fieldComments.isEmpty();
    }

    public List<String> getClassComments() {
        return this.classComments;
    }

    public Map<String, List<String>> getFieldComments() {
        return this.fieldComments;
    }
}

