/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.config;

import info.cho.passwords.fairy.config.Configuration;
import info.cho.passwords.fairy.config.FieldMapper;
import info.cho.passwords.fairy.config.Reflect;
import info.cho.passwords.fairy.config.annotation.ElementType;
import java.lang.reflect.Field;

public interface Converter<S, T> {
    public T convertTo(S var1, ConversionInfo var2);

    default public void preConvertTo(ConversionInfo info) {
    }

    public S convertFrom(T var1, ConversionInfo var2);

    default public void preConvertFrom(ConversionInfo info) {
    }

    public static final class ConversionInfo {
        private final FieldMapper.MappingInfo mappingInfo;
        private final Field field;
        private final Object instance;
        private final Object value;
        private final Object mapValue;
        private final Class<?> fieldType;
        private final Class<?> valueType;
        private final Class<?> elementType;
        private final String fieldName;
        private final Configuration.Properties props;
        private final int nestingLevel;
        private int currentNestingLevel;

        private ConversionInfo(Field field, Object instance, Object mapValue, FieldMapper.MappingInfo mappingInfo) {
            this.mappingInfo = mappingInfo;
            this.field = field;
            this.instance = instance;
            this.value = Reflect.getValue(field, instance);
            this.mapValue = mapValue;
            this.fieldType = field.getType();
            this.valueType = this.value.getClass();
            this.fieldName = field.getName();
            this.props = mappingInfo.getProperties();
            this.elementType = ConversionInfo.elementType(field);
            this.nestingLevel = ConversionInfo.nestingLevel(field);
        }

        private static Class<?> elementType(Field field) {
            if (field.isAnnotationPresent(ElementType.class)) {
                ElementType et = field.getAnnotation(ElementType.class);
                return et.value();
            }
            return null;
        }

        private static int nestingLevel(Field field) {
            if (field.isAnnotationPresent(ElementType.class)) {
                ElementType et = field.getAnnotation(ElementType.class);
                return et.nestingLevel();
            }
            return -1;
        }

        static ConversionInfo from(Field field, Object instance, FieldMapper.MappingInfo mappingInfo) {
            return new ConversionInfo(field, instance, null, mappingInfo);
        }

        static ConversionInfo from(Field field, Object instance, Object mapValue, FieldMapper.MappingInfo mappingInfo) {
            return new ConversionInfo(field, instance, mapValue, mappingInfo);
        }

        public Field getField() {
            return this.field;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Object getInstance() {
            return this.instance;
        }

        public Object getValue() {
            return this.value;
        }

        public Object getMapValue() {
            return this.mapValue;
        }

        public Class<?> getFieldType() {
            return this.fieldType;
        }

        public Class<?> getValueType() {
            return this.valueType;
        }

        public Configuration.Properties getProperties() {
            return this.props;
        }

        public Class<?> getElementType() {
            return this.elementType;
        }

        public boolean hasElementType() {
            return this.elementType != null;
        }

        int getNestingLevel() {
            return this.nestingLevel;
        }

        int getCurrentNestingLevel() {
            return this.currentNestingLevel;
        }

        void incCurrentNestingLevel() {
            ++this.currentNestingLevel;
        }

        public FieldMapper.MappingInfo getMappingInfo() {
            return this.mappingInfo;
        }
    }
}

