/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.config;

import info.cho.passwords.fairy.config.ConfigurationException;
import info.cho.passwords.fairy.config.Converter;
import info.cho.passwords.fairy.config.Converters;
import info.cho.passwords.fairy.config.Reflect;
import info.cho.passwords.fairy.container.Autowired;
import info.cho.passwords.fairy.container.SerializerFactory;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class Validator {
    @Autowired
    private static SerializerFactory serializerFactory;

    Validator() {
    }

    static void checkNotNull(Object o, String fn) {
        if (o == null) {
            String msg = "The value of field '" + fn + "' is null.\nPlease assign a non-null default value or remove this field.";
            throw new ConfigurationException(msg);
        }
    }

    static void checkContainerTypes(Converter.ConversionInfo info) {
        Object value = info.getValue();
        Collection<?> collection = Validator.toCollection(value);
        Validator.checkCollectionTypes(collection, info);
    }

    private static void checkCollectionTypes(Collection<?> collection, Converter.ConversionInfo info) {
        for (Object element : collection) {
            if (Reflect.isContainerType(element.getClass())) {
                Collection<?> container = Validator.toCollection(element);
                Validator.checkCollectionTypes(container, info);
                continue;
            }
            Validator.checkCollectionType(element, info);
        }
    }

    private static void checkCollectionType(Object element, Converter.ConversionInfo info) {
        if (!info.getElementType().isInstance(element)) {
            String cNameField = Validator.selectContainerNameField(info);
            String cValues = Validator.selectContainerValues(info);
            String msg = "The type of " + cNameField + " doesn't match the type indicated by the ElementType annotation.\nRequired type: '" + Validator.getClsName(info.getElementType()) + "'\tActual type: '" + Validator.getClsName(element.getClass()) + "'\n" + cValues;
            throw new ConfigurationException(msg);
        }
    }

    private static String selectContainerValues(Converter.ConversionInfo info) {
        Object value = info.getValue();
        return Converters.selector("All elements: " + value, "All elements: " + value, "All entries: " + value).apply(info.getValueType());
    }

    private static String selectContainerNameField(Converter.ConversionInfo info) {
        String fieldName = info.getFieldName();
        return Converters.selector("an element of list '" + fieldName + "'", "an element of set '" + fieldName + "'", "a value of map '" + fieldName + "'").apply(info.getValueType());
    }

    private static Collection<?> toCollection(Object container) {
        if (container instanceof List || container instanceof Set) {
            return (Collection)container;
        }
        Map map = (Map)container;
        return map.values();
    }

    static void checkMapKeysAndValues(Converter.ConversionInfo info) {
        Validator.checkMapKeysSimple((Map)info.getValue(), info.getFieldName());
        Validator.checkContainerValuesNotNull(info);
    }

    private static void checkMapKeysSimple(Map<?, ?> map, String fn) {
        for (Object o : map.keySet()) {
            if (Reflect.isSimpleType(o.getClass())) continue;
            String msg = "The keys of map '" + fn + "' must be simple types.";
            throw new ConfigurationException(msg);
        }
    }

    static void checkContainerValuesNotNull(Converter.ConversionInfo info) {
        Collection<?> collection = Validator.toCollection(info.getValue());
        Validator.checkCollectionValuesNotNull(collection, info);
    }

    private static void checkCollectionValuesNotNull(Collection<?> col, Converter.ConversionInfo info) {
        for (Object element : col) {
            Validator.checkCollectionValueNotNull(element, info);
            if (!Reflect.isContainerType(element.getClass())) continue;
            Collection<?> container = Validator.toCollection(element);
            Validator.checkCollectionValuesNotNull(container, info);
        }
    }

    private static void checkCollectionValueNotNull(Object element, Converter.ConversionInfo info) {
        if (element == null) {
            String cnf = Validator.selectContainerNameField(info).replaceFirst("a", "A");
            String msg = cnf + " is null.\nPlease either remove or replace this element.\n" + Validator.selectContainerValues(info);
            throw new ConfigurationException(msg);
        }
    }

    static void checkContainerValuesSimpleType(Converter.ConversionInfo info) {
        Collection<?> collection = Validator.toCollection(info.getValue());
        Validator.checkCollectionValuesSimpleType(collection, info);
    }

    private static void checkCollectionValuesSimpleType(Collection<?> collection, Converter.ConversionInfo info) {
        for (Object element : collection) {
            if (Reflect.isContainerType(element.getClass())) {
                Collection<?> elements = Validator.toCollection(element);
                Validator.checkCollectionValuesSimpleType(elements, info);
                continue;
            }
            Validator.checkCollectionValueSimpleType(element, info);
        }
    }

    private static void checkCollectionValueSimpleType(Object element, Converter.ConversionInfo info) {
        if (!Reflect.isSimpleType(element.getClass())) {
            String cn = Converters.selectContainerName(info.getValueType());
            String cnf = Validator.selectContainerNameField(info);
            String fieldName = info.getFieldName();
            String msg = "The type of " + cnf + " is not a simple type but " + cn + " '" + fieldName + "' is missing the ElementType annotation.\n" + Validator.selectContainerValues(info);
            throw new ConfigurationException(msg);
        }
    }

    static void checkTypeIsConfigurationElement(Class<?> cls, String fn) {
        if (!Reflect.isConfigurationElement(cls)) {
            String msg = "Type '" + Validator.getClsName(cls) + "' of field '" + fn + "' is not annotated as a configuration element.";
            throw new ConfigurationException(msg);
        }
    }

    private static String getClsName(Class<?> cls) {
        String clsName = cls.getSimpleName();
        if (clsName.equals("")) {
            clsName = cls.getName();
        }
        return clsName;
    }

    static void checkIsMap(Object value, String fn) {
        Class<?> cls = value.getClass();
        if (!Map.class.isAssignableFrom(cls)) {
            String msg = "Initializing field '" + fn + "' requires a Map<String, Object> but the given object is not a map.\nType: '" + cls.getSimpleName() + "'\tValue: '" + value + "'";
            throw new ConfigurationException(msg);
        }
    }

    static void checkMapKeysAreStrings(Map<?, ?> map, String fn) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = entry.getKey();
            if (key != null && key.getClass() == String.class) continue;
            String msg = "Initializing field '" + fn + "' requires a Map<String, Object> but the given map contains non-string keys.\nAll entries: " + map;
            throw new ConfigurationException(msg);
        }
    }

    static void checkElementType(Converter.ConversionInfo info) {
        Class<?> elementType = info.getElementType();
        if (serializerFactory.findSerializer(elementType) != null) {
            return;
        }
        if (!elementType.isEnum()) {
            Validator.checkElementTypeIsConfigurationElement(info);
        }
        Validator.checkElementTypeIsConcrete(info);
        if (!elementType.isEnum()) {
            Validator.checkElementTypeHasNoArgsConstructor(info);
        }
    }

    static void checkFieldWithElementTypeIsContainer(Converter.ConversionInfo info) {
        boolean isContainer = Reflect.isContainerType(info.getValueType());
        if (info.hasElementType() && !isContainer) {
            String msg = "Field '" + info.getFieldName() + "' is annotated with the ElementType annotation but is not a List, Set or Map.";
            throw new ConfigurationException(msg);
        }
    }

    private static void checkElementTypeIsConfigurationElement(Converter.ConversionInfo info) {
        Class<?> elementType = info.getElementType();
        if (!Reflect.isConfigurationElement(elementType)) {
            String msg = "The element type '" + Validator.getClsName(elementType) + "' of field '" + info.getFieldName() + "' is not a configuration element.";
            throw new ConfigurationException(msg);
        }
    }

    private static void checkElementTypeIsConcrete(Converter.ConversionInfo info) {
        Class<?> elementType = info.getElementType();
        String msg = Validator.getType(elementType);
        if (msg != null) {
            msg = "The element type of field '" + info.getFieldName() + "' must be a concrete class but type '" + Validator.getClsName(elementType) + "' is " + msg;
            throw new ConfigurationException(msg);
        }
    }

    private static String getType(Class<?> cls) {
        String msg = null;
        if (cls.isInterface()) {
            msg = "an interface.";
        } else if (cls.isPrimitive()) {
            msg = "primitive.";
        } else if (cls.isArray()) {
            msg = "an array.";
        } else if (Modifier.isAbstract(cls.getModifiers())) {
            msg = "an abstract class.";
        }
        return msg;
    }

    private static void checkElementTypeHasNoArgsConstructor(Converter.ConversionInfo info) {
        Class<?> elementType = info.getElementType();
        if (!Reflect.hasNoArgConstructor(elementType)) {
            String msg = "The element type '" + elementType.getSimpleName() + "' of field '" + info.getFieldName() + "' doesn't have a no-args constructor.";
            throw new ConfigurationException(msg);
        }
    }

    static void checkTypeHasNoArgsConstructor(Converter.ConversionInfo info) {
        Class<?> valueType = info.getValueType();
        if (!Reflect.hasNoArgConstructor(valueType)) {
            String msg = "Type '" + Validator.getClsName(valueType) + "' of field '" + info.getFieldName() + "' doesn't have a no-args constructor.";
            throw new ConfigurationException(msg);
        }
    }

    static void checkConverterHasNoArgsConstructor(Class<?> converterClass, String fn) {
        if (!Reflect.hasNoArgConstructor(converterClass)) {
            String msg = "Converter '" + converterClass.getSimpleName() + "' used on field '" + fn + "' doesn't have a no-args constructor.";
            throw new ConfigurationException(msg);
        }
    }

    static void checkEnumValueIsString(Converter.ConversionInfo info) {
        Object val = info.getMapValue();
        if (!(val instanceof String)) {
            String sn = val.getClass().getSimpleName();
            String msg = "Initializing enum '" + info.getFieldName() + "' requires a string but '" + val + "' is of type '" + sn + "'.";
            throw new ConfigurationException(msg);
        }
    }

    static void checkFieldTypeAssignableFrom(Class<?> type, Converter.ConversionInfo info) {
        Class<?> fieldType = info.getFieldType();
        if (!fieldType.isAssignableFrom(type)) {
            String msg = "Can not set field '" + info.getFieldName() + "' with type '" + Validator.getClsName(fieldType) + "' to '" + Validator.getClsName(type) + "'.";
            throw new ConfigurationException(msg);
        }
    }

    static void checkElementIsConvertibleToConfigurationElement(Object element, Converter.ConversionInfo info) {
        Class<?> eClass = element.getClass();
        if (Reflect.isContainerType(info.getFieldType()) && !Map.class.isAssignableFrom(eClass)) {
            String msg = "Initializing field '" + info.getFieldName() + "' requires objects of type Map<String, Object> but element '" + element + "' is of type '" + Validator.getClsName(eClass) + "'.";
            throw new IllegalArgumentException(msg);
        }
    }

    static void checkNestingLevel(Object element, Converter.ConversionInfo info) {
        if (!Reflect.isContainerType(element.getClass()) && info.getNestingLevel() != info.getCurrentNestingLevel()) {
            String msg = "Field '" + info.getFieldName() + "' of class '" + Validator.getClsName(info.getInstance().getClass()) + "' has a nesting level of " + info.getNestingLevel() + " but the first object of type '" + Validator.getClsName(info.getElementType()) + "' was found on level " + info.getCurrentNestingLevel() + ".";
            throw new ConfigurationException(msg);
        }
    }

    static void checkCurrentLevelSameAsExpectedRequiresMapOrString(boolean currentLevelSameAsExpected, Object element, Converter.ConversionInfo info) {
        boolean isMapOrString;
        boolean bl = isMapOrString = element instanceof Map || element instanceof String;
        if (currentLevelSameAsExpected && !isMapOrString) {
            Class<?> cls = info.getInstance().getClass();
            String msg = "Field '" + info.getFieldName() + "' of class '" + Validator.getClsName(cls) + "' has a nesting level of " + info.getNestingLevel() + " but element '" + element + "' of type '" + Validator.getClsName(element.getClass()) + "' cannot be converted to '" + Validator.getClsName(info.getElementType()) + "'.";
            throw new ConfigurationException(msg);
        }
    }

    static void checkElementTypeIsEnumType(Class<?> type, Converter.ConversionInfo info) {
        if (!Reflect.isEnumType(type)) {
            String msg = "Element type '" + Validator.getClsName(type) + "' of field '" + info.getFieldName() + "' is not an enum type.";
            throw new IllegalArgumentException(msg);
        }
    }

    static void checkConverterNotReturnsNull(Object converted, Converter.ConversionInfo info) {
        if (converted == null) {
            String msg = "Failed to convert value '" + info.getValue() + "' of field '" + info.getFieldName() + "' because the converter returned null.";
            throw new ConfigurationException(msg);
        }
    }
}

